/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats.utils;

import com.logviewer.formats.utils.LvLayoutCustomTypeNode;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LvLayoutStretchNode
extends LvLayoutCustomTypeNode {
    protected final boolean removeSpacesBefore;
    protected final int minSize;
    protected int start;
    protected int end;

    public LvLayoutStretchNode(@NonNull String fieldName, @Nullable String fieldType, boolean removeSpacesBefore, int minSize) {
        super(fieldName, fieldType);
        this.removeSpacesBefore = removeSpacesBefore;
        this.minSize = minSize;
        assert (minSize >= 0);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean reset(String s, int start, int endStr) {
        this.start = start;
        if (start + this.minSize > endStr) {
            return false;
        }
        this.end = start + this.minSize;
        return true;
    }

    @Override
    public final int parse(String s, int offset, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeSpacesBefore() {
        return this.removeSpacesBefore && this.minSize > 0;
    }

    @Override
    public int getValueStart(String s, int idx, int endStr) {
        if (!this.removeSpacesBefore) {
            return idx;
        }
        while (idx < endStr && s.charAt(idx) == ' ') {
            ++idx;
        }
        return idx;
    }

    public int getMinSize() {
        return this.minSize;
    }

    @Override
    public LvLayoutStretchNode clone() {
        return new LvLayoutStretchNode(this.getFieldName(), this.getFieldType(), this.removeSpacesBefore, this.minSize);
    }

    public static LvLayoutStretchNode threadNode() {
        return new LvLayoutStretchNode("thread", "thread", true, 1);
    }

    public static LvLayoutStretchNode messageNode() {
        return new LvLayoutStretchNode("msg", "message", true, 0);
    }

    public boolean grow(String s, int targetPosition, int endStr) {
        assert (targetPosition <= endStr);
        if (this.end < targetPosition) {
            this.end = targetPosition;
        }
        return true;
    }
}

