/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats.utils;

import com.logviewer.formats.utils.LvLayoutNode;
import com.logviewer.formats.utils.LvLayoutNodeSearchable;
import org.springframework.lang.NonNull;

public class LvLayoutTextNode
implements LvLayoutNode,
LvLayoutNodeSearchable,
Cloneable {
    protected final String txt;
    private final String trimmedStartTxt;
    protected final int prefixSpaces;

    private LvLayoutTextNode(String txt, String trimmedStartTxt, int prefixSpaces) {
        this.txt = txt;
        this.trimmedStartTxt = trimmedStartTxt;
        this.prefixSpaces = prefixSpaces;
    }

    @Override
    public int parse(String s, int offset, int end) {
        int nonSpaceIdx;
        for (nonSpaceIdx = offset; nonSpaceIdx < end && s.charAt(nonSpaceIdx) == ' '; ++nonSpaceIdx) {
        }
        int spaceCount = nonSpaceIdx - offset;
        if (spaceCount < this.prefixSpaces) {
            return -2147483647;
        }
        if (end - nonSpaceIdx < this.trimmedStartTxt.length() || !s.startsWith(this.trimmedStartTxt, nonSpaceIdx)) {
            return -2147483647;
        }
        return nonSpaceIdx + this.trimmedStartTxt.length();
    }

    @Override
    public boolean removeSpacesBefore() {
        return false;
    }

    @Override
    public LvLayoutTextNode clone() {
        try {
            return (LvLayoutTextNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.txt;
    }

    @Override
    public int search(String s, int offset, int end) {
        return s.indexOf(this.txt, offset);
    }

    public static LvLayoutTextNode of(@NonNull String txt) {
        assert (txt.length() > 0);
        int prefixSpaces = 0;
        while (true) {
            if (prefixSpaces == txt.length()) {
                return new LvLayoutTextNode(txt, "", prefixSpaces){

                    @Override
                    public int parse(String s, int offset, int end) {
                        int next = offset + this.prefixSpaces;
                        if (next <= end && s.startsWith(this.txt, offset)) {
                            return next;
                        }
                        return -2147483647;
                    }
                };
            }
            if (txt.charAt(prefixSpaces) != ' ') break;
            ++prefixSpaces;
        }
        if (prefixSpaces == 0 && txt.length() == 1) {
            return new LvLayoutTextNode(txt, txt, 0){
                private final char a;
                {
                    this.a = this.txt.charAt(0);
                }

                @Override
                public int parse(String s, int offset, int end) {
                    int next = offset + 1;
                    if (next <= end && s.charAt(offset) == this.a) {
                        return next;
                    }
                    return -2147483647;
                }

                @Override
                public boolean removeSpacesBefore() {
                    return true;
                }
            };
        }
        return new LvLayoutTextNode(txt, txt.substring(prefixSpaces), prefixSpaces);
    }
}

