/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.impl;

import com.logviewer.data2.FavoriteLogService;
import java.util.ArrayList;
import java.util.List;

public class InmemoryFavoritesService
implements FavoriteLogService {
    private final List<String> favorites = new ArrayList<String>();
    private boolean editable = true;

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void clear() {
        this.favorites.clear();
    }

    @Override
    public synchronized List<String> getFavorites() {
        return new ArrayList<String>(this.favorites);
    }

    @Override
    public synchronized List<String> addFavoriteLog(String path) {
        if (!this.isEditable()) {
            throw new IllegalStateException("Favorites list is not editable");
        }
        if (!this.favorites.contains(path)) {
            this.favorites.add(path);
        }
        return new ArrayList<String>(this.favorites);
    }

    @Override
    public List<String> removeFavorite(String path) {
        if (!this.isEditable()) {
            throw new IllegalStateException("Favorites list is not editable");
        }
        this.favorites.remove(path);
        return new ArrayList<String>(this.favorites);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }
}

