/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.impl;

import com.logviewer.api.LvFileAccessManager;
import com.logviewer.api.LvFileNavigationManager;
import com.logviewer.impl.LvFsItemImpl;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LvFileNavigationManagerImpl
implements LvFileNavigationManager {
    private final LvFileAccessManager fileAccessManager;
    @Value(value="${log-viewer.default-directory:}")
    private String defaultDirectory;

    public LvFileNavigationManagerImpl(@NonNull LvFileAccessManager fileAccessManager) {
        this.fileAccessManager = fileAccessManager;
    }

    @Override
    @Nullable
    public Path getDefaultDirectory() {
        Path userHomePath;
        if (!this.defaultDirectory.isEmpty()) {
            return Paths.get(this.defaultDirectory, new String[0]);
        }
        List<Path> roots = this.fileAccessManager.getRoots();
        if (roots.stream().allMatch(r -> r.getParent() == null) && this.fileAccessManager.isDirectoryVisible(userHomePath = Paths.get(System.getProperty("user.home"), new String[0]))) {
            return userHomePath;
        }
        if (roots.size() == 1) {
            return roots.get(0);
        }
        return null;
    }

    @Override
    @NonNull
    public List<LvFileNavigationManager.LvFsItem> getChildren(@Nullable Path path) throws SecurityException, IOException {
        if (path != null && !path.isAbsolute()) {
            throw new SecurityException("path must be absolute");
        }
        if (path != null && !this.fileAccessManager.isDirectoryVisible(path)) {
            throw new SecurityException(this.fileAccessManager.errorMessage(path));
        }
        try {
            Stream<Path> paths = path == null ? this.fileAccessManager.getRoots().stream() : Files.list(path);
            return paths.filter(f -> {
                if (Files.isDirectory(f, new LinkOption[0])) {
                    return this.fileAccessManager.isDirectoryVisible((Path)f);
                }
                return this.fileAccessManager.isFileVisible((Path)f);
            }).map(LvFsItemImpl::create).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (AccessDeniedException e) {
            throw new SecurityException("Not enough permissions to access file or directory");
        }
    }

    public LvFileNavigationManagerImpl setDefaultDirectory(@NonNull String defaultDirectory) {
        this.defaultDirectory = defaultDirectory;
        return this;
    }
}

