/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.impl;

import com.logviewer.api.LvFileNavigationManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.springframework.lang.Nullable;

public class LvFsItemImpl
implements LvFileNavigationManager.LvFsItem {
    private final Path path;
    private final BasicFileAttributes attributes;

    public LvFsItemImpl(Path path, BasicFileAttributes attributes) {
        this.path = path;
        this.attributes = attributes;
    }

    @Override
    public boolean isDirectory() {
        return this.attributes.isDirectory();
    }

    @Override
    public long getSize() {
        if (this.attributes.isDirectory()) {
            return -1L;
        }
        return this.attributes.size();
    }

    @Override
    @Nullable
    public Long getModificationTime() {
        if (this.attributes.isDirectory()) {
            return null;
        }
        return this.attributes.lastModifiedTime().toMillis();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public static LvFsItemImpl create(Path path) {
        BasicFileAttributes attr;
        try {
            attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException | SecurityException e) {
            return null;
        }
        return new LvFsItemImpl(path, attr);
    }
}

