/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.logLibs;

import com.logviewer.data2.LogFormat;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;

public class LoggerLibSupport {
    private static final LoggerLibSupport[] LIB_SUPPORTS = new LoggerLibSupport[]{new LoggerLibSupport("logback", "ch.qos.logback.classic.LoggerContext", "com.logviewer.logLibs.logback.LogbackConfigImporter", "com.logviewer.logLibs.logback.LogbackLogFormat"), new LoggerLibSupport("log4j", "org.apache.logging.log4j.core.LoggerContext", "com.logviewer.logLibs.log4j.Log4jConfigImporter", null)};
    private final String name;
    private final String libClassToTest;
    private final String configImporterClassName;
    private Supplier<Map<Path, LogFormat>> configImporter;
    private final String logFormatClassName;
    private Class<LogFormat> logFormatClass;

    public LoggerLibSupport(String name, String libClassToTest, String configImporterClassName, @Nullable String logFormatClassName) {
        this.name = name;
        this.libClassToTest = libClassToTest;
        this.configImporterClassName = configImporterClassName;
        this.logFormatClassName = logFormatClassName;
    }

    public String getName() {
        return this.name;
    }

    public Stream<Class<? extends LogFormat>> getFormatClasses() {
        if (this.logFormatClass == null) {
            if (this.logFormatClassName == null) {
                return Stream.empty();
            }
            try {
                this.logFormatClass = this.getClass().getClassLoader().loadClass(this.logFormatClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return Stream.of(this.logFormatClass);
    }

    public Supplier<Map<Path, LogFormat>> getConfigImporter() {
        if (this.configImporter == null) {
            try {
                Class<?> cls = this.getClass().getClassLoader().loadClass(this.configImporterClassName);
                this.configImporter = (Supplier)cls.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.configImporter;
    }

    public static Stream<LoggerLibSupport> getSupportedLogLibs() {
        return Stream.of(LIB_SUPPORTS).filter(logLibs -> {
            try {
                LoggerLibSupport.class.getClassLoader().loadClass(logLibs.libClassToTest);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        });
    }
}

