/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.logLibs.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.ScanException;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.config.VisibleDirectory;
import com.logviewer.formats.AbstractPatternLogFormat;
import com.logviewer.logLibs.logback.LogbackLogFormat;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackConfigImporter
implements Supplier<Map<Path, LogFormat>> {
    private static final Logger LOG = LoggerFactory.getLogger(LogbackConfigImporter.class);

    private static void processAppender(Appender<ILoggingEvent> appender, Set<Appender<ILoggingEvent>> processedAppenders, ArrayList<VisibleDirectory> visibleDirectories, Map<Path, LogFormat> res) {
        if (!processedAppenders.add(appender)) {
            return;
        }
        if (appender instanceof FileAppender) {
            FileAppender fileAppender = (FileAppender)appender;
            Encoder encoder = fileAppender.getEncoder();
            if (!(encoder instanceof PatternLayoutEncoder)) {
                throw new IllegalStateException("Failed to import log config - unsupported encoder: " + encoder.getClass());
            }
            try {
                File file = new File(fileAppender.getFile()).getCanonicalFile();
                File parent = file.getParentFile();
                if (parent == null) {
                    return;
                }
                PatternLayoutEncoder patternEncoder = (PatternLayoutEncoder)encoder;
                String pattern = LogbackConfigImporter.patchPatternWithProcessId(patternEncoder.getPattern());
                AbstractPatternLogFormat logFormat = new LogbackLogFormat(pattern).setCharset(patternEncoder.getCharset());
                try {
                    logFormat.validate();
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Failed to import log configuration, invalid pattern: " + patternEncoder.getPattern(), (Throwable)e);
                    logFormat = null;
                }
                visibleDirectories.add(new VisibleDirectory(parent.getPath(), Pattern.quote(file.getName())));
                res.put(file.toPath(), logFormat);
            }
            catch (IOException e) {
                LOG.error("Failed to import log configuration", (Throwable)e);
            }
        } else if (appender instanceof AppenderAttachable) {
            Iterator itr = ((AppenderAttachable)appender).iteratorForAppenders();
            while (itr.hasNext()) {
                LogbackConfigImporter.processAppender((Appender<ILoggingEvent>)((Appender)itr.next()), processedAppenders, visibleDirectories, res);
            }
        }
    }

    protected static String getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        Matcher matcher = Pattern.compile("(\\d+)@").matcher(name);
        if (!matcher.lookingAt()) {
            return null;
        }
        return matcher.group(1);
    }

    protected static String patchPatternWithProcessId(String pattern) {
        String processId = LogbackConfigImporter.getProcessId();
        if (processId == null) {
            return pattern;
        }
        Pattern pidPattern = Pattern.compile("\\b" + processId + "\\b");
        Matcher matcher = pidPattern.matcher(pattern);
        if (!matcher.find()) {
            return pattern;
        }
        if (matcher.find()) {
            return pattern;
        }
        if (!LogbackConfigImporter.hasLiteral(pattern, pidPattern)) {
            return pattern;
        }
        return pidPattern.matcher(pattern).replaceFirst("%processId");
    }

    private static boolean hasLiteral(String pattern, Pattern pid) {
        try {
            Parser parser = new Parser(pattern);
            for (Node node = parser.parse(); node != null; node = node.getNext()) {
                Matcher matcher;
                if (node.getType() != 0 || !(matcher = pid.matcher((String)node.getValue())).find()) continue;
                return true;
            }
            return false;
        }
        catch (ScanException e) {
            return false;
        }
    }

    @Override
    public Map<Path, LogFormat> get() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ArrayList<VisibleDirectory> visibleDirectories = new ArrayList<VisibleDirectory>();
        HashSet<Appender<ILoggingEvent>> processedAppenders = new HashSet<Appender<ILoggingEvent>>();
        HashMap<Path, LogFormat> res = new HashMap<Path, LogFormat>();
        for (ch.qos.logback.classic.Logger logger : loggerContext.getLoggerList()) {
            Iterator index = logger.iteratorForAppenders();
            while (index.hasNext()) {
                LogbackConfigImporter.processAppender((Appender<ILoggingEvent>)((Appender)index.next()), processedAppenders, visibleDirectories, res);
            }
        }
        return res;
    }
}

