/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.services;

import com.logviewer.api.LvFilterStorage;
import com.logviewer.data2.config.ConfigDirHolder;
import com.logviewer.utils.PersistentMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class FileSystemFilterStorage
implements LvFilterStorage,
InitializingBean {
    private final ConfigDirHolder configDir;
    private PersistentMap persistentMap;

    public FileSystemFilterStorage(ConfigDirHolder configDir) {
        this.configDir = configDir;
    }

    public void afterPropertiesSet() {
        String maxSizeStr = this.configDir.getProperty("filter.state.max.size");
        int maxSize = maxSizeStr == null ? 0x200000 : Integer.parseInt(maxSizeStr);
        this.persistentMap = new PersistentMap(this.configDir.getConfigDir().resolve("filters_state.data"), maxSize);
    }

    @Override
    @Nullable
    public String loadFilterStateByHash(@NonNull String hash) {
        return this.persistentMap.get(hash);
    }

    @Override
    public void saveFilterSet(@NonNull String hash, @NonNull String filters) {
        this.persistentMap.put(hash, filters);
    }
}

