/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.utils;

import com.logviewer.data2.LogFilterContext;
import com.logviewer.data2.LogRecord;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.RuntimeInterruptedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;

public class TestPredicate
implements RecordPredicate {
    public static final long WAIT_TIMEOUT = Integer.getInteger("test-wait-timeout", 5) * 1000;
    private static final Map<Object, Predicate<LogRecord>> lockMap = new LinkedHashMap<Object, Predicate<LogRecord>>();
    private static final List<LogRecord> passed = new ArrayList<LogRecord>();
    private static final Set<LogRecord> waited = new HashSet<LogRecord>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(LogRecord record) {
        try {
            Class<TestPredicate> clazz = TestPredicate.class;
            synchronized (TestPredicate.class) {
                boolean added = false;
                try {
                    while (lockMap.values().stream().anyMatch(p -> p.test(record))) {
                        if (!added) {
                            waited.add(record);
                            added = true;
                        }
                        TestPredicate.class.notifyAll();
                        TestPredicate.class.wait();
                    }
                    List<LogRecord> list = passed;
                    synchronized (list) {
                        passed.add(record);
                        passed.notifyAll();
                    }
                }
                finally {
                    if (added) {
                        waited.remove(record);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        {
            return;
        }
    }

    @Override
    public boolean test(LogRecord record, LogFilterContext ctx) {
        TestPredicate.handle(record);
        return true;
    }

    public static boolean wasProcessed(String record) {
        return TestPredicate.wasProcessed((LogRecord r) -> r.getMessage().equals(record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wasProcessed(Predicate<LogRecord> p) {
        List<LogRecord> list = passed;
        synchronized (list) {
            return passed.stream().anyMatch(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LogRecord> getPassed() {
        List<LogRecord> list = passed;
        synchronized (list) {
            return new ArrayList<LogRecord>(passed);
        }
    }

    public static void waitForRecord(@NonNull String record) throws InterruptedException {
        TestPredicate.waitForRecord((LogRecord r) -> r.getMessage().equals(record));
    }

    public static void waitForRecord(Predicate<LogRecord> p) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        List<LogRecord> list = passed;
        synchronized (list) {
            do {
                if (passed.stream().anyMatch(p)) {
                    return;
                }
                passed.wait(500L);
            } while (System.currentTimeMillis() - startTime <= WAIT_TIMEOUT);
            throw new RuntimeException();
        }
    }

    public static synchronized Object lock(Pattern pattern) {
        return TestPredicate.lock((LogRecord record) -> pattern.matcher(record.getMessage()).matches());
    }

    public static synchronized Object lock(String line) {
        return TestPredicate.lock((LogRecord record) -> record.getMessage().equals(line));
    }

    public static synchronized Object lock(Predicate<LogRecord> p) {
        Object key = new Object();
        lockMap.put(key, p);
        return key;
    }

    public static synchronized boolean unlock(Object key) {
        if (lockMap.remove(key) != null) {
            TestPredicate.class.notifyAll();
            return true;
        }
        return false;
    }

    public static void waitForLocked(String line) throws InterruptedException {
        TestPredicate.waitForLocked((LogRecord record) -> record.getMessage().equals(line));
    }

    public static synchronized void waitForLocked(Predicate<LogRecord> predicate) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        do {
            if (waited.stream().anyMatch(predicate)) {
                return;
            }
            TestPredicate.class.wait(500L);
        } while (System.currentTimeMillis() - startTime <= WAIT_TIMEOUT);
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void clear() {
        lockMap.clear();
        TestPredicate.class.notifyAll();
        List<LogRecord> list = passed;
        synchronized (list) {
            passed.clear();
            passed.notifyAll();
        }
    }
}

