/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web;

import com.logviewer.data2.LogContextHolder;
import com.logviewer.utils.LvGsonUtils;
import com.logviewer.utils.RuntimeInterruptedException;
import com.logviewer.utils.Utils;
import com.logviewer.web.dto.events.BackendErrorEvent;
import com.logviewer.web.dto.events.BackendEvent;
import com.logviewer.web.rmt.MethodCall;
import com.logviewer.web.rmt.RemoteInvoker;
import com.logviewer.web.session.LogSession;
import com.logviewer.web.session.SessionAdapter;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class LogViewerWebsocket
extends Endpoint {
    private static final Logger LOG = LoggerFactory.getLogger(LogViewerWebsocket.class);
    private static final String LOG_SESSION = "log-session";
    @Autowired
    private ApplicationContext applicationContext;

    public void onOpen(Session webSession, EndpointConfig config) {
        LOG.info("Connection opened: {} {}", (Object)webSession.getId(), (Object)LogViewerWebsocket.getUserName(webSession));
        webSession.setMaxIdleTimeout(0L);
        ApplicationContext context = LogContextHolder.getInstance();
        if (context == null && (context = this.applicationContext) == null) {
            throw new RuntimeException("Spring context not found. Set ApplicationContext to com.logviewer.data2.LogContextHolder.setInstance(appCtx)");
        }
        final SessionAdapter sessionAdapter = event -> this.sendMessage(webSession, event);
        final LogSession session = LogSession.fromContext(sessionAdapter, context);
        webSession.getUserProperties().put(LOG_SESSION, session);
        webSession.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                try {
                    MethodCall call = (MethodCall)LvGsonUtils.GSON.fromJson(message, MethodCall.class);
                    RemoteInvoker.call(session, call);
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getTargetException();
                    }
                    LOG.error("Remote method execution error", e);
                    sessionAdapter.send(new BackendErrorEvent(Utils.getStackTraceAsString(e)));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(Session webSession, BackendEvent event) {
        String json = LvGsonUtils.GSON.toJson((Object)event);
        Session session = webSession;
        synchronized (session) {
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeInterruptedException();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Send message " + json);
            }
            webSession.getAsyncRemote().sendText(json, result -> {
                if (!result.isOK() && webSession.isOpen()) {
                    LOG.error("Failed to send message", result.getException());
                    Utils.closeQuietly((AutoCloseable)webSession);
                }
            });
        }
    }

    public void onError(Session session, Throwable thr) {
        LOG.error("websocket error", thr);
        this.close(session);
    }

    private void close(Session session) {
        LogSession logSession = (LogSession)session.getUserProperties().get(LOG_SESSION);
        if (logSession != null) {
            logSession.shutdown();
        }
    }

    public void onClose(Session webSession, CloseReason reason) {
        String text = "Connection closed (" + reason.toString() + ") " + webSession.getId() + " " + LogViewerWebsocket.getUserName(webSession);
        if (reason.getCloseCode() == CloseReason.CloseCodes.NORMAL_CLOSURE || reason.getCloseCode() == CloseReason.CloseCodes.GOING_AWAY) {
            LOG.info(text);
        } else {
            LOG.error(text);
        }
        this.close(webSession);
    }

    private static String getUserName(Session webSession) {
        Principal userPrincipal = webSession.getUserPrincipal();
        if (userPrincipal == null) {
            return "<anonymous>";
        }
        return userPrincipal.getName();
    }
}

