/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web;

import com.logviewer.utils.DelegateProxy;
import com.logviewer.utils.LvGsonUtils;
import com.logviewer.utils.LvTimer;
import com.logviewer.utils.Utils;
import com.logviewer.web.AbstractRestRequestHandler;
import com.logviewer.web.Endpoint;
import com.logviewer.web.LvAsyncContext;
import com.logviewer.web.LvServletRequest;
import com.logviewer.web.LvServletResponse;
import com.logviewer.web.RestException;
import com.logviewer.web.dto.events.BackendErrorEvent;
import com.logviewer.web.dto.events.BackendEvent;
import com.logviewer.web.rmt.MethodCall;
import com.logviewer.web.rmt.RemoteInvoker;
import com.logviewer.web.session.LogSession;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.html.FormSubmitEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class WebsocketEmulationController
extends AbstractRestRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketEmulationController.class);
    @Value(value="${log-viewer.ws-emulator.max-connection-count:1000}")
    private int maxConnections;
    @Value(value="${log-viewer.ws-emulator.max-message-queue-size:40}")
    private int maxMessageQueueSize;
    @Value(value="${log-viewer.ws-emulator.connection-hold-time:20000}")
    private long connectionHoldTime;
    @Value(value="${log-viewer.ws-emulator.wait-connection-timeout:10000}")
    private long waitConnectionTimeout;
    @Autowired
    private LvTimer timer;
    @Autowired
    private ApplicationContext applicationContext;
    private final Map<String, ConnectionSession> sessions = new HashMap<String, ConnectionSession>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Endpoint(method={FormSubmitEvent.MethodType.POST})
    public void closeSession(String sessionId) {
        ConnectionSession session;
        Map<String, ConnectionSession> map = this.sessions;
        synchronized (map) {
            session = this.sessions.remove(sessionId);
        }
        if (session != null) {
            session.close("page closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Endpoint(method={FormSubmitEvent.MethodType.POST})
    public Object request(RestRequestBody body) throws Throwable {
        ConnectionSession connectionSession;
        LOG.debug("handling request [sessionId={}, requestNumber={}-{}]", new Object[]{body.sessionId, body.messages.length == 0 ? "<none>" : Long.valueOf(body.messages[0].messageNumber), body.messages.length == 0 ? "<none>" : Long.valueOf(body.messages[body.messages.length - 1].messageNumber)});
        Map<String, ConnectionSession> map = this.sessions;
        synchronized (map) {
            connectionSession = this.sessions.get(body.sessionId);
            if (connectionSession == null) {
                if (body.messages.length == 0 || body.messages[0].messageNumber != 0L) {
                    throw new RestException(410, "Server connection has been closed");
                }
                if (this.sessions.size() >= this.maxConnections) {
                    throw new RestException(429, "Too many connections: " + this.maxConnections);
                }
                connectionSession = new ConnectionSession(body.sessionId, this.getUserName());
                this.sessions.put(body.sessionId, connectionSession);
                LOG.info("Connection opened [sessionId={}, user={}]", (Object)body.sessionId, (Object)connectionSession.userName);
            }
        }
        return connectionSession.handleRequest(this.getRequest(), body.messages);
    }

    private String getUserName() {
        Principal userPrincipal = this.getRequest().getUserPrincipal();
        if (userPrincipal == null) {
            return "<anonymous>";
        }
        return userPrincipal.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<ConnectionSession> connectionSessions;
        Map<String, ConnectionSession> map = this.sessions;
        synchronized (map) {
            connectionSessions = new ArrayList<ConnectionSession>(this.sessions.values());
            this.sessions.clear();
        }
        for (ConnectionSession value : connectionSessions) {
            try {
                value.close("application stopping");
            }
            catch (Throwable e) {
                LOG.error("Failed to close page: {}", (Object)value.sessionId, (Object)e);
            }
        }
    }

    private class ConnectionSession {
        private final String sessionId;
        private final LogSession logSession;
        private long backendMessageCounter;
        private final Queue<ToBackendMessage> toBackendQueue = new PriorityQueue<ToBackendMessage>();
        private long uiMessageCounter;
        private final List<ToUiMessage> toUiQueue = new ArrayList<ToUiMessage>();
        private LvAsyncContext asyncContext;
        private TimerTask asyncContextChecker;
        private final AtomicBoolean closed = new AtomicBoolean();
        private final String userName;
        private final Runnable timeoutTask = () -> this.close("timeout");

        public ConnectionSession(@NonNull String sessionId, String userName) {
            this.sessionId = sessionId;
            this.userName = userName;
            this.logSession = LogSession.fromContext(this::sendEvent, WebsocketEmulationController.this.applicationContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object handleRequest(LvServletRequest request, ToBackendMessage[] requests) throws Throwable {
            try {
                this.addRequestToQueue(requests);
                this.processRequestsInQueue();
                List<ToUiMessage> list = this.toUiQueue;
                synchronized (list) {
                    if (this.closed.get()) {
                        return Collections.emptyList();
                    }
                    if (this.asyncContextChecker != null) {
                        this.asyncContextChecker.cancel();
                    }
                    if (this.asyncContext != null) {
                        LOG.debug("release held connection [sessionId={}, sentMessages={}]", (Object)this.sessionId, (Object)this.toUiQueue.size());
                        this.writeResponse(DelegateProxy.create(LvServletResponse.class, this.asyncContext.getResponse()), this.toUiQueue);
                        this.toUiQueue.clear();
                        this.asyncContext.complete();
                        this.asyncContext = null;
                    }
                    if (!this.toUiQueue.isEmpty()) {
                        ArrayList<ToUiMessage> res = new ArrayList<ToUiMessage>(this.toUiQueue);
                        this.toUiQueue.clear();
                        this.asyncContextChecker = WebsocketEmulationController.this.timer.schedule(this.timeoutTask, WebsocketEmulationController.this.waitConnectionTimeout);
                        LOG.debug("return response [sessionId={}, sentMessages={}", (Object)this.sessionId, (Object)res.size());
                        return res;
                    }
                    this.asyncContext = DelegateProxy.create(LvAsyncContext.class, request.startAsync());
                    this.asyncContext.setTimeout(WebsocketEmulationController.this.connectionHoldTime + 10000L);
                    this.asyncContextChecker = WebsocketEmulationController.this.timer.schedule(this.asyncContextCloserTask(this.asyncContext), WebsocketEmulationController.this.connectionHoldTime);
                    LOG.debug("connection has held [sessionId={}]", (Object)this.sessionId);
                    return this.asyncContext;
                }
            }
            catch (Throwable e) {
                this.close("internal error");
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addRequestToQueue(ToBackendMessage[] messages) {
            Queue<ToBackendMessage> queue = this.toBackendQueue;
            synchronized (queue) {
                if (this.toUiQueue.size() >= WebsocketEmulationController.this.maxMessageQueueSize) {
                    throw new RestException(429, "Too many connections: " + this.sessionId);
                }
                Collections.addAll(this.toBackendQueue, messages);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendEvent(BackendEvent event) {
            List<ToUiMessage> list = this.toUiQueue;
            synchronized (list) {
                if (this.closed.get()) {
                    return;
                }
                this.toUiQueue.add(new ToUiMessage(this.uiMessageCounter++, event));
                if (this.asyncContext != null) {
                    this.sendResponseQueueToAsync();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processRequestsInQueue() {
            while (true) {
                ToBackendMessage r;
                Queue<ToBackendMessage> queue = this.toBackendQueue;
                synchronized (queue) {
                    r = this.toBackendQueue.peek();
                    if (r == null || r.messageNumber != this.backendMessageCounter) {
                        return;
                    }
                    this.toBackendQueue.remove();
                }
                try {
                    RemoteInvoker.call(this.logSession, r.event);
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getTargetException();
                    }
                    LOG.error("Remote method execution error", e);
                    this.sendEvent(new BackendErrorEvent(Utils.getStackTraceAsString(e)));
                    break;
                }
                queue = this.toBackendQueue;
                synchronized (queue) {
                    ++this.backendMessageCounter;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(@NonNull String reason) {
            assert (!Thread.holdsLock(this.toBackendQueue));
            assert (!Thread.holdsLock(this.toUiQueue));
            if (this.closed.compareAndSet(false, true)) {
                Object object = WebsocketEmulationController.this.sessions;
                synchronized (object) {
                    WebsocketEmulationController.this.sessions.remove(this.sessionId, this);
                }
                this.logSession.shutdown();
                object = this.toUiQueue;
                synchronized (object) {
                    if (this.asyncContextChecker != null) {
                        this.asyncContextChecker.cancel();
                    }
                    if (this.asyncContext != null) {
                        this.asyncContext.complete();
                        this.asyncContext = null;
                    }
                }
                LOG.info("Connection closed [sessionId={}, user={}, reason={}]", new Object[]{this.sessionId, this.userName, reason});
            }
        }

        private void writeResponse(LvServletResponse resp, @Nullable List<ToUiMessage> res) throws IOException {
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
            if (res == null) {
                resp.getWriter().write("[]");
            } else {
                LvGsonUtils.GSON.toJson(res, (Appendable)resp.getWriter());
            }
        }

        private void sendResponseQueueToAsync() {
            assert (Thread.holdsLock(this.toUiQueue));
            this.asyncContextChecker.cancel();
            boolean success = false;
            try {
                LOG.debug("release held connection [sessionId={}, sentMessages={}]", (Object)this.sessionId, (Object)this.toUiQueue.size());
                this.writeResponse(DelegateProxy.create(LvServletResponse.class, this.asyncContext.getResponse()), this.toUiQueue);
                this.toUiQueue.clear();
                this.asyncContext.complete();
                this.asyncContext = null;
                this.asyncContextChecker = WebsocketEmulationController.this.timer.schedule(this.timeoutTask, WebsocketEmulationController.this.waitConnectionTimeout);
                success = true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!success) {
                    this.close("internal error");
                }
            }
        }

        private Runnable asyncContextCloserTask(LvAsyncContext ctx) {
            WeakReference<Object> expectedContext = new WeakReference<Object>(DelegateProxy.getDelegate(ctx));
            return () -> {
                List<ToUiMessage> list = this.toUiQueue;
                synchronized (list) {
                    if (this.closed.get()) {
                        return;
                    }
                    Object context = expectedContext.get();
                    if (context == null || context != DelegateProxy.getDelegate(this.asyncContext)) {
                        return;
                    }
                    this.sendResponseQueueToAsync();
                }
            };
        }
    }

    private static class RestRequestBody {
        private String sessionId;
        private ToBackendMessage[] messages;

        private RestRequestBody() {
        }
    }

    private static class ToBackendMessage
    implements Comparable<ToBackendMessage> {
        private long messageNumber;
        private MethodCall event;

        private ToBackendMessage() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToBackendMessage)) {
                return false;
            }
            ToBackendMessage request = (ToBackendMessage)o;
            return this.messageNumber == request.messageNumber;
        }

        public int hashCode() {
            return (int)this.messageNumber;
        }

        @Override
        public int compareTo(ToBackendMessage o) {
            return Long.compare(this.messageNumber, o.messageNumber);
        }
    }

    private static class ToUiMessage {
        private final long messageNumber;
        private final BackendEvent event;

        public ToUiMessage(long responseNumber, BackendEvent event) {
            this.messageNumber = responseNumber;
            this.event = event;
        }
    }
}

