/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.dto;

import com.logviewer.data2.LogView;
import com.logviewer.web.dto.RestField;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RestLog {
    private final String id;
    private final String path;
    private final String node;
    private final String url;
    private final boolean connected;
    private final boolean hasFullDate;
    private final String format;
    private final List<RestField> fields;

    public RestLog(LogView log) {
        this.id = log.getId();
        this.node = log.getHostname();
        this.path = log.getPath().getFile();
        this.connected = log.isConnected();
        this.url = log.getPath().getNode() == null ? log.getPath().getFile() : log.getPath().getFile() + '@' + log.getPath().getNode().toString();
        this.fields = Stream.of(log.getFormat().getFields()).map(RestField::new).collect(Collectors.toList());
        this.format = log.getFormat().getHumanReadableString();
        this.hasFullDate = log.getFormat().hasFullDate();
    }
}

