/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.dto;

import com.google.gson.annotations.JsonAdapter;
import com.logviewer.data2.LogRecord;
import com.logviewer.utils.GsonNanosecondsAdapter;
import com.logviewer.utils.Pair;
import com.logviewer.utils.TextRange;
import com.logviewer.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class RestRecord {
    private final String logId;
    private final String s;
    private final long start;
    private final long end;
    private int loadedTextLengthBytes;
    @JsonAdapter(value=GsonNanosecondsAdapter.class)
    private final Long time;
    private final List<RestField> fields;
    private final String filteringError;

    public RestRecord(@NonNull LogRecord record) {
        this(record, null);
    }

    public RestRecord(@NonNull Pair<LogRecord, Throwable> pair) {
        this(pair.getFirst(), pair.getSecond() == null ? null : Utils.getStackTraceAsString(pair.getSecond()));
    }

    public RestRecord(@NonNull LogRecord record, @Nullable String filteringError) {
        this.logId = record.getLogId();
        this.s = record.getMessage();
        this.start = record.getStart();
        this.end = record.getEnd();
        this.loadedTextLengthBytes = record.getLoadedTextLengthBytes();
        this.fields = new ArrayList<RestField>();
        for (String fieldName : record.getFieldNames()) {
            TextRange fieldOffset = record.getFieldOffset(fieldName);
            if (fieldOffset == null) continue;
            this.fields.add(new RestField(fieldName, fieldOffset.getStart(), fieldOffset.getEnd()));
        }
        this.filteringError = filteringError;
        this.time = record.getTime();
    }

    public String getLogId() {
        return this.logId;
    }

    public String fieldValue(@NonNull String fieldName) {
        return this.fields.stream().filter(f -> f.name.equals(fieldName)).findFirst().map(f -> this.s.substring(f.start, f.end)).orElse(null);
    }

    public String getText() {
        return this.s;
    }

    public String toString() {
        return this.s;
    }

    public static List<RestRecord> fromPairList(@Nullable List<Pair<LogRecord, Throwable>> pairs) {
        if (pairs == null) {
            return null;
        }
        ArrayList<RestRecord> res = new ArrayList<RestRecord>(pairs.size());
        for (Pair<LogRecord, Throwable> pair : pairs) {
            res.add(new RestRecord(pair));
        }
        return res;
    }

    private static class RestField {
        String name;
        int start;
        int end;

        public RestField(String name, int start, int end) {
            this.name = name;
            this.start = start;
            this.end = end;
        }
    }
}

