/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.session.tasks;

import com.logviewer.data2.LogRecord;
import com.logviewer.data2.LogView;
import com.logviewer.data2.Position;
import com.logviewer.data2.RecordList;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.Pair;
import com.logviewer.web.session.LogDataListener;
import com.logviewer.web.session.LogProcess;
import com.logviewer.web.session.SessionTask;
import com.logviewer.web.session.Status;
import com.logviewer.web.session.tasks.LoadNextResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LoadRecordTask
extends SessionTask<LoadNextResponse> {
    static final Comparator<Pair<LogRecord, Throwable>> PAIR_COMPARATOR = Comparator.comparing(Pair::getFirst);
    protected final int recordCount;
    protected final RecordPredicate filter;
    @Nullable
    protected final Position start;
    protected final boolean backward;
    @Nullable
    protected final Map<String, String> hashes;
    protected final Comparator<Pair<LogRecord, Throwable>> comparator;
    protected final Map<LogView, LogProcess> loaders = new IdentityHashMap<LogView, LogProcess>();
    protected final Map<String, Status> statuses = new HashMap<String, Status>();
    protected final List<Pair<LogRecord, Throwable>> data = new ArrayList<Pair<LogRecord, Throwable>>();
    protected boolean eof = true;
    protected boolean finished;

    public LoadRecordTask(@NonNull LogView[] logs, int recordCount, RecordPredicate filter, @Nullable Position start, boolean backward, @Nullable Map<String, String> hashes) {
        super(logs);
        this.recordCount = recordCount;
        this.start = start;
        this.hashes = hashes;
        assert (recordCount > 0);
        this.backward = backward;
        this.filter = filter;
        this.comparator = backward ? PAIR_COMPARATOR.reversed() : PAIR_COMPARATOR;
    }

    @Override
    public synchronized void execute(BiConsumer<LoadNextResponse, Throwable> consumer) {
        LogView[] logs = this.hashes == null ? this.logs : (LogView[])Stream.of(this.logs).filter(l -> this.hashes.get(l.getId()) != null).toArray(LogView[]::new);
        if (logs.length == 0) {
            this.finished = true;
            consumer.accept(new LoadNextResponse(Collections.emptyList(), this.statuses, true), null);
            return;
        }
        for (LogView log : logs) {
            String hash = this.hashes == null ? null : this.hashes.get(log.getId());
            LogProcess loader = log.loadRecords(this.filter, this.recordCount, this.start, this.backward, hash, 51200L, new MyLogDataListener(log, consumer));
            this.loaders.put(log, loader);
        }
        this.loaders.values().forEach(LogProcess::start);
    }

    @Nullable
    public Map<String, String> getHashes() {
        return this.hashes;
    }

    @Nullable
    public Position getStart() {
        return this.start;
    }

    public boolean isBackward() {
        return this.backward;
    }

    public RecordPredicate getFilter() {
        return this.filter;
    }

    @Override
    public synchronized void cancel() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.loaders.values().forEach(LogProcess::cancel);
    }

    protected long getTimeLimit(LogRecord lastRecord, LogView log) {
        if (this.backward) {
            if (log.getId().compareTo(lastRecord.getLogId()) > 0) {
                return lastRecord.getTime() - 1L;
            }
            return lastRecord.getTime();
        }
        if (log.getId().compareTo(lastRecord.getLogId()) < 0) {
            return lastRecord.getTime() + 1L;
        }
        return lastRecord.getTime();
    }

    protected class MyLogDataListener
    implements LogDataListener {
        private final LogView log;
        private final BiConsumer<LoadNextResponse, Throwable> consumer;

        public MyLogDataListener(LogView log, BiConsumer<LoadNextResponse, Throwable> consumer) {
            this.log = log;
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onData(@NonNull RecordList newRecords) {
            LoadRecordTask loadRecordTask = LoadRecordTask.this;
            synchronized (loadRecordTask) {
                LogRecord oldLastRecord;
                if (LoadRecordTask.this.finished) {
                    return;
                }
                assert (!LoadRecordTask.this.statuses.containsKey(this.log.getId()));
                LogRecord logRecord = oldLastRecord = LoadRecordTask.this.data.size() == LoadRecordTask.this.recordCount ? LoadRecordTask.this.data.get(LoadRecordTask.this.recordCount - 1).getFirst() : null;
                if (LoadRecordTask.this.loaders.size() > 1) {
                    for (Pair newRecord : newRecords) {
                        if (!((LogRecord)newRecord.getFirst()).hasTime()) continue;
                        LoadRecordTask.this.data.add(newRecord);
                    }
                    LoadRecordTask.this.data.sort(LoadRecordTask.this.comparator);
                } else {
                    LoadRecordTask.this.data.addAll(newRecords);
                }
                if (LoadRecordTask.this.data.size() > LoadRecordTask.this.recordCount) {
                    LoadRecordTask.this.eof = false;
                    do {
                        LoadRecordTask.this.data.remove(LoadRecordTask.this.data.size() - 1);
                    } while (LoadRecordTask.this.data.size() > LoadRecordTask.this.recordCount);
                }
                if (LoadRecordTask.this.data.size() == LoadRecordTask.this.recordCount) {
                    LogRecord lastRecord = LoadRecordTask.this.data.get(LoadRecordTask.this.recordCount - 1).getFirst();
                    LoadRecordTask.this.loaders.forEach((l, loader) -> {
                        if (oldLastRecord == null || LoadRecordTask.this.getTimeLimit(oldLastRecord, (LogView)l) != LoadRecordTask.this.getTimeLimit(lastRecord, (LogView)l)) {
                            loader.setTimeLimit(LoadRecordTask.this.getTimeLimit(lastRecord, (LogView)l));
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFinish(@NonNull Status status, boolean eof) {
            LoadRecordTask loadRecordTask = LoadRecordTask.this;
            synchronized (loadRecordTask) {
                if (LoadRecordTask.this.finished) {
                    return;
                }
                LoadRecordTask.this.statuses.put(this.log.getId(), status);
                if (status.getError() == null) {
                    LoadRecordTask.this.eof &= eof;
                }
                if (LoadRecordTask.this.statuses.size() == LoadRecordTask.this.loaders.size()) {
                    LoadRecordTask.this.finished = true;
                }
            }
            if (LoadRecordTask.this.finished) {
                if (LoadRecordTask.this.backward) {
                    Collections.reverse(LoadRecordTask.this.data);
                }
                this.consumer.accept(new LoadNextResponse(LoadRecordTask.this.data, LoadRecordTask.this.statuses, LoadRecordTask.this.eof), null);
            }
        }
    }
}

