/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery.main;

import io.narayana.openshift.txrecovery.cliargs.ParsedArguments;
import io.narayana.openshift.txrecovery.main.ProcessorMethods;
import java.util.List;

public class ProgramProcessor {
    private ProcessorMethods methods;

    public ProgramProcessor(ProcessorMethods methods) {
        this.methods = methods;
    }

    public List<String> process(ParsedArguments parsedArguments) {
        switch (parsedArguments.getCommand()) {
            case CREATE: {
                return this.methods.create();
            }
            case INSERT: {
                this.verifyExistenceApplicationPod(parsedArguments);
                this.verifyExistenceRecoveryPod(parsedArguments);
                return this.methods.insert();
            }
            case DELETE: {
                return this.methods.delete();
            }
            case SELECT_APPLICATION: {
                return this.methods.selectApplication();
            }
            case SELECT_RECOVERY: {
                return this.methods.selectRecovery();
            }
        }
        throw new IllegalArgumentException("Unknown handler for command '" + (Object)((Object)parsedArguments.getCommand()) + "'");
    }

    private void verifyExistenceApplicationPod(ParsedArguments parsedArguments) {
        String appPodSelect = parsedArguments.getApplicationPodName();
        if (appPodSelect == null || appPodSelect.isEmpty()) {
            throw new IllegalArgumentException("For command '" + parsedArguments.getCommand().name() + "' application pod name has to be specified. Use cli argument '-a/--application_pod_name'. Arguments were: " + parsedArguments);
        }
    }

    private void verifyExistenceRecoveryPod(ParsedArguments parsedArguments) {
        String recPodSelect = parsedArguments.getRecoveryPodName();
        if (recPodSelect == null || recPodSelect.isEmpty()) {
            throw new IllegalArgumentException("For command '" + parsedArguments.getCommand().name() + "' recovery pod name has to be specified. Use cli argument '-r/--recovery_pod_name'. Arguments were : " + parsedArguments);
        }
    }
}

