/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery;

import io.narayana.openshift.txrecovery.cliargs.ArgumentParserException;
import io.narayana.openshift.txrecovery.cliargs.ParsedArguments;
import io.narayana.openshift.txrecovery.common.DBH2Connector;
import io.narayana.openshift.txrecovery.types.CommandType;
import io.narayana.openshift.txrecovery.types.DatabaseType;
import io.narayana.openshift.txrecovery.types.OutputFormatType;
import org.junit.Assert;
import org.junit.Test;

public class ArgumentParserTest {
    @Test
    public void allShortOptions() throws Exception {
        String[] args = new String[]{"-y", "h2", "-i", "org.hibernate.dialect.H2Dialect", "-j", "org.h2.Driver", "-l", "jdbc:h2:mem:test", "-o", "localhost", "-p", "1111", "-d", "test_db", "-u", "test_user", "-s", "test_pass", "-t", "test_table", "-c", "create", "-a", "name_of_app_pod", "-r", "name_of_recovery_pod", "-f", "raw", "-v"};
        ParsedArguments ap = ParsedArguments.parse((String[])args);
        Assert.assertEquals((Object)DatabaseType.H2, (Object)ap.getTypeDb());
        Assert.assertEquals((Object)"org.hibernate.dialect.H2Dialect", (Object)ap.getHibernateDialect());
        Assert.assertEquals((Object)"org.h2.Driver", (Object)ap.getJdbcDriverClass());
        Assert.assertEquals((Object)"jdbc:h2:mem:test", (Object)ap.getJdbcUrl());
        Assert.assertEquals((Object)"localhost", (Object)ap.getHost());
        Assert.assertEquals((Object)1111, (Object)ap.getPort());
        Assert.assertEquals((Object)"test_db", (Object)ap.getDatabase());
        Assert.assertEquals((Object)"test_user", (Object)ap.getUser());
        Assert.assertEquals((Object)"test_pass", (Object)ap.getPassword());
        Assert.assertEquals((Object)"test_table", (Object)ap.getTableName());
        Assert.assertEquals((Object)CommandType.CREATE, (Object)ap.getCommand());
        Assert.assertEquals((Object)"name_of_app_pod", (Object)ap.getApplicationPodName());
        Assert.assertEquals((Object)"name_of_recovery_pod", (Object)ap.getRecoveryPodName());
        Assert.assertEquals((Object)OutputFormatType.RAW, (Object)ap.getFormat());
    }

    @Test
    public void openshiftOptions() throws Exception {
        String[] args = new String[]{"-y", "postgresql", "-o", "172.30.109.102", "-p", "5432", "-d", "root", "-u", "userBqL", "-s", "Fcvkt5n4", "-t", "recmark_eapapp", "-c", "delete", "-a", "eap-app-1-lzxnf", "-r", "eap-app-migration-1-gxfn6"};
        ParsedArguments ap = ParsedArguments.parse((String[])args);
        Assert.assertEquals((Object)DatabaseType.POSTGRESQL, (Object)ap.getTypeDb());
        Assert.assertEquals((Object)"org.hibernate.dialect.PostgreSQL82Dialect", (Object)ap.getHibernateDialect());
        Assert.assertEquals((Object)"org.postgresql.Driver", (Object)ap.getJdbcDriverClass());
        Assert.assertEquals((Object)"jdbc:postgresql://172.30.109.102:5432/root", (Object)ap.getJdbcUrl());
        Assert.assertEquals((Object)"172.30.109.102", (Object)ap.getHost());
        Assert.assertEquals((Object)5432, (Object)ap.getPort());
        Assert.assertEquals((Object)"root", (Object)ap.getDatabase());
        Assert.assertEquals((Object)"userBqL", (Object)ap.getUser());
        Assert.assertEquals((Object)"Fcvkt5n4", (Object)ap.getPassword());
        Assert.assertEquals((Object)"recmark_eapapp", (Object)ap.getTableName());
        Assert.assertEquals((Object)CommandType.DELETE, (Object)ap.getCommand());
        Assert.assertEquals((Object)"eap-app-1-lzxnf", (Object)ap.getApplicationPodName());
        Assert.assertEquals((Object)"eap-app-migration-1-gxfn6", (Object)ap.getRecoveryPodName());
    }

    @Test
    public void allLongOptions() throws Exception {
        String[] args = new String[]{"--type_db", "h2", "--hibernate_dialect", "org.hibernate.dialect.H2Dialect", "--jdbc_driver_class", "org.h2.Driver", "--url", "jdbc:h2:mem:test", "--host", "localhost", "--port", "1111", "--database", "test_db", "--user", "test_user", "--password", "test_pass", "--table_name", "test_table", "--command", "create", "--application_pod_name", "name_of_app_pod", "--recovery_pod_name", "name_of_recovery_pod", "--format", "raw", "--verbose"};
        ParsedArguments ap = ParsedArguments.parse((String[])args);
        Assert.assertEquals((Object)DatabaseType.H2, (Object)ap.getTypeDb());
        Assert.assertEquals((Object)"org.hibernate.dialect.H2Dialect", (Object)ap.getHibernateDialect());
        Assert.assertEquals((Object)"org.h2.Driver", (Object)ap.getJdbcDriverClass());
        Assert.assertEquals((Object)"jdbc:h2:mem:test", (Object)ap.getJdbcUrl());
        Assert.assertEquals((Object)"localhost", (Object)ap.getHost());
        Assert.assertEquals((Object)1111, (Object)ap.getPort());
        Assert.assertEquals((Object)"test_db", (Object)ap.getDatabase());
        Assert.assertEquals((Object)"test_user", (Object)ap.getUser());
        Assert.assertEquals((Object)"test_pass", (Object)ap.getPassword());
        Assert.assertEquals((Object)"test_table", (Object)ap.getTableName());
        Assert.assertEquals((Object)CommandType.CREATE, (Object)ap.getCommand());
        Assert.assertEquals((Object)"name_of_app_pod", (Object)ap.getApplicationPodName());
        Assert.assertEquals((Object)"name_of_recovery_pod", (Object)ap.getRecoveryPodName());
        Assert.assertEquals((Object)OutputFormatType.RAW, (Object)ap.getFormat());
    }

    @Test
    public void databaseNotDefined() throws Exception {
        block2: {
            String[] args = new String[]{"-y", "h2", "-o", "localhost", "-p", "1111", "-u", "test_user", "-s", "test_password"};
            try {
                ParsedArguments.parse((String[])args);
            }
            catch (ArgumentParserException ape) {
                if (ape.getCause() instanceof IllegalArgumentException) break block2;
                throw ape;
            }
        }
    }

    @Test
    public void databaseDuplicated() throws Exception {
        String[] args = new String[]{"-y", "h2", "-d", "my_db", "-u", "test_user", "-s", "test_password", "-d", "test_dbname"};
        ParsedArguments ap = ParsedArguments.parse((String[])args);
        Assert.assertEquals((Object)"test_dbname", (Object)ap.getDatabase());
    }

    @Test
    public void h2Settings() throws Exception {
        ParsedArguments ap = ParsedArguments.parse((String[])DBH2Connector.H2_CONNECTION_ARGS);
        Assert.assertEquals((Object)DatabaseType.H2, (Object)ap.getTypeDb());
        Assert.assertEquals((Object)"org.hibernate.dialect.H2Dialect", (Object)ap.getHibernateDialect());
        Assert.assertEquals((Object)"org.h2.Driver", (Object)ap.getJdbcDriverClass());
        Assert.assertEquals((Object)"jdbc:h2:mem:txn-recovery-marker-test;DB_CLOSE_DELAY=-1", (Object)ap.getJdbcUrl());
        Assert.assertEquals((Object)"localhost", (Object)ap.getHost());
        Assert.assertEquals((Object)5432, (Object)ap.getPort());
        Assert.assertEquals((Object)"", (Object)ap.getUser());
        Assert.assertEquals((Object)"", (Object)ap.getPassword());
        Assert.assertEquals((Object)"TEST_TABLE", (Object)ap.getTableName());
    }
}

