/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.jboss.logging.Logger;

public class DBH2Connector {
    private static final Logger log = Logger.getLogger(DBH2Connector.class);
    public static final String[] H2_CONNECTION_ARGS = new String[]{"-y", "h2", "-l", "jdbc:h2:mem:txn-recovery-marker-test;DB_CLOSE_DELAY=-1", "-u", "", "-s", "", "-t", "TEST_TABLE"};
    public static final String DB_NAME = "txn-recovery-marker-test";
    public static final String DB_TABLE_NAME = "TEST_TABLE";
    public static final String DB_H2_CONNECTION = "jdbc:h2:mem:txn-recovery-marker-test;DB_CLOSE_DELAY=-1";
    private DataSource ds;

    public DBH2Connector() {
        JdbcDataSource h2ds = new JdbcDataSource();
        h2ds.setUrl(DB_H2_CONNECTION);
        this.ds = h2ds;
    }

    public String selectAll() {
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM TEST_TABLE");
            StringBuffer sb = new StringBuffer();
            while (rs.next()) {
                sb.append(rs.getString(1)).append(",").append(rs.getString(2)).append(";");
            }
            String string = sb.toString();
            return string;
        }
        catch (SQLException sqle) {
            throw new IllegalStateException("Cannot select data from ds '" + this.ds + "'", sqle);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Cannot close while selecting from ds '%s'", (Object)this.ds);
            }
        }
    }

    public void dropTable() {
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            conn.createStatement().executeUpdate("DROP TABLE TEST_TABLE");
        }
        catch (SQLException sqle) {
            throw new IllegalStateException("Cannot drop table TEST_TABLE from ds '" + this.ds + "'", sqle);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Cannot close while dropping table from ds '%s'", (Object)this.ds);
            }
        }
    }
}

