/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery.cliargs;

import io.narayana.openshift.txrecovery.cliargs.ArgumentParser;
import io.narayana.openshift.txrecovery.cliargs.ArgumentParserException;
import io.narayana.openshift.txrecovery.cliargs.Options;
import io.narayana.openshift.txrecovery.logging.I18NLogger;
import io.narayana.openshift.txrecovery.types.CommandType;
import io.narayana.openshift.txrecovery.types.DatabaseType;
import io.narayana.openshift.txrecovery.types.OutputFormatType;
import java.text.MessageFormat;

public final class ParsedArguments {
    public static final String DEFAULT_TABLE_NAME = "JDBC_RECOVERY";
    public static final String DEFAULT_DB_TYPE = DatabaseType.POSTGRESQL.name();
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "5432";
    public static final String DEFAULT_COMMAND = CommandType.SELECT_RECOVERY.name();
    private static Options ARGS_OPTIONS = new Options().addOption("y", "type_db", true, I18NLogger.logger.msg_typeDb()).addOption("i", "hibernate_dialect", true, I18NLogger.logger.msg_hibernateDialect()).addOption("j", "jdbc_driver_class", true, I18NLogger.logger.msg_jdbcDriverClass()).addOption("l", "url", true, I18NLogger.logger.msg_url()).addOption("o", "host", true, I18NLogger.logger.msg_host()).addOption("p", "port", true, I18NLogger.logger.msg_port()).addOption("d", "database", true, I18NLogger.logger.msg_database()).addRequiredOption("u", "user", true, I18NLogger.logger.msg_user()).addRequiredOption("s", "password", true, I18NLogger.logger.msg_password()).addOption("t", "table_name", true, I18NLogger.logger.msg_tableName()).addOption("c", "command", true, I18NLogger.logger.msg_command()).addOption("a", "application_pod_name", true, I18NLogger.logger.msg_applicationPodName()).addOption("r", "recovery_pod_name", true, I18NLogger.logger.msg_recoveryPodName()).addOption("f", "format", true, I18NLogger.logger.msg_format()).addOption("v", "verbose", false, I18NLogger.logger.msg_verbose()).addOption("h", "help", false, I18NLogger.logger.msg_help());
    private DatabaseType typeDb;
    private String hibernateDialect;
    private String jdbcDriverClass;
    private String jdbcUrl;
    private String host;
    private String database;
    private String user;
    private String password;
    private String tableName;
    private Integer port;
    private CommandType command;
    private String applicationPodName;
    private String recoveryPodName;
    private OutputFormatType format;
    private boolean isVerbose;

    public static ParsedArguments parse(String ... args) throws ArgumentParserException {
        return new ParsedArguments(args);
    }

    private ParsedArguments(String ... args) throws ArgumentParserException {
        ArgumentParser parser = new ArgumentParser();
        try {
            parser.parse(ARGS_OPTIONS, args);
            if (parser.hasOption("help")) {
                this.printHelpStdErr();
                System.exit(2);
            }
            String value = parser.getOptionValue("type_db", DEFAULT_DB_TYPE);
            this.typeDb = DatabaseType.valueOf(value.toUpperCase());
            this.hibernateDialect = parser.getOptionValue("hibernate_dialect", this.typeDb.dialect());
            this.jdbcDriverClass = parser.getOptionValue("jdbc_driver_class", this.typeDb.jdbcDriverClasss());
            this.jdbcUrl = parser.getOptionValue("url");
            this.host = parser.getOptionValue("host", DEFAULT_HOST);
            value = parser.getOptionValue("port", DEFAULT_PORT);
            this.port = Integer.valueOf(value);
            this.database = parser.getOptionValue("database");
            if (this.jdbcUrl == null && (this.host.isEmpty() || this.database == null)) {
                throw new IllegalArgumentException("Argument '-l/--url' is empty and there is not enough data for construction jdbc url. Please add --host, --port and --database.");
            }
            this.user = parser.getOptionValue("user");
            this.password = parser.getOptionValue("password");
            this.tableName = parser.getOptionValue("table_name", DEFAULT_TABLE_NAME);
            value = parser.getOptionValue("command", DEFAULT_COMMAND);
            this.command = CommandType.valueOf(value.toUpperCase());
            this.applicationPodName = parser.getOptionValue("application_pod_name");
            this.recoveryPodName = parser.getOptionValue("recovery_pod_name");
            value = parser.getOptionValue("format", OutputFormatType.LIST_SPACE.name());
            this.format = OutputFormatType.valueOf(value.toUpperCase());
            this.isVerbose = parser.hasOption("verbose");
        }
        catch (Exception pe) {
            System.err.println(pe.getMessage());
            this.printHelpStdErr();
            throw new ArgumentParserException(pe);
        }
    }

    void printHelpStdErr() {
        System.err.println(I18NLogger.logger.msg_errHelpMessage());
        ARGS_OPTIONS.printHelpToStdErr();
    }

    public static Options getARGS_OPTIONS() {
        return ARGS_OPTIONS;
    }

    public DatabaseType getTypeDb() {
        return this.typeDb;
    }

    public String getHibernateDialect() {
        return this.hibernateDialect;
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Integer getPort() {
        return this.port;
    }

    public CommandType getCommand() {
        return this.command;
    }

    public String getApplicationPodName() {
        return this.applicationPodName;
    }

    public String getRecoveryPodName() {
        return this.recoveryPodName;
    }

    public OutputFormatType getFormat() {
        return this.format;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public String getJdbcDriverClass() {
        return this.jdbcDriverClass;
    }

    public String getJdbcUrl() {
        if (this.jdbcUrl != null) {
            return this.jdbcUrl;
        }
        return MessageFormat.format(this.typeDb.jdbcUrlPattern(), this.host, this.port, this.database);
    }

    public String toString() {
        return String.format("[command: %s, dbtype: %s, url: %s, host: %s, port: %s, db: %s, user: %s, pass: %s, table: %s, dialect: %s, driver: %s, app: %s, recovery: %s, format: %s, verbose: %s]", new Object[]{this.command, this.typeDb, this.jdbcUrl, this.host, this.port, this.database, this.user, this.password, this.tableName, this.hibernateDialect, this.jdbcDriverClass, this.applicationPodName, this.recoveryPodName, this.format, this.isVerbose ? "true" : "false"});
    }
}

