/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery.hibernate;

import io.narayana.openshift.txrecovery.cliargs.ParsedArguments;
import java.util.Optional;
import java.util.Properties;

public final class HibernateProperties {
    private static final String DB_TABLE_NAME_PARAM = "db.table.name";
    private static final String HIBERNATE_DIALECT_PARAM = "hibernate.dialect";
    private static final String HIBERNATE_CONNECTION_DRIVER_CLASS_PARAM = "hibernate.connection.driver_class";
    private static final String HIBERNATE_CONNECTION_URL_PARAM = "hibernate.connection.url";
    private static final String HIBERNATE_CONNECTION_USERNAME_PARAM = "hibernate.connection.username";
    private static final String HIBERNATE_CONNECTION_PASSWORD_PARAM = "hibernate.connection.password";

    private HibernateProperties() {
    }

    public static Properties setupPropertiesByParsedArguments(ParsedArguments args) {
        Properties outputProperties = HibernateProperties.prepareHibernateBasicProperties();
        HibernateProperties.setIfNotNull(HIBERNATE_DIALECT_PARAM, args.getHibernateDialect(), outputProperties);
        HibernateProperties.setIfNotNull(HIBERNATE_CONNECTION_DRIVER_CLASS_PARAM, args.getJdbcDriverClass(), outputProperties);
        HibernateProperties.setIfNotNull(HIBERNATE_CONNECTION_URL_PARAM, args.getJdbcUrl(), outputProperties);
        HibernateProperties.setIfNotNull(HIBERNATE_CONNECTION_USERNAME_PARAM, args.getUser(), outputProperties);
        HibernateProperties.setIfNotNull(HIBERNATE_CONNECTION_PASSWORD_PARAM, args.getPassword(), outputProperties);
        HibernateProperties.setIfNotNull(DB_TABLE_NAME_PARAM, args.getTableName(), outputProperties);
        return outputProperties;
    }

    private static Properties prepareHibernateBasicProperties() {
        Properties outputProperties = new Properties();
        HibernateProperties.getDefaultForPropertyKey(HIBERNATE_DIALECT_PARAM, outputProperties);
        HibernateProperties.getDefaultForPropertyKey(HIBERNATE_CONNECTION_DRIVER_CLASS_PARAM, outputProperties);
        HibernateProperties.getDefaultForPropertyKey(HIBERNATE_CONNECTION_URL_PARAM, outputProperties);
        HibernateProperties.getDefaultForPropertyKey(HIBERNATE_CONNECTION_USERNAME_PARAM, outputProperties);
        HibernateProperties.getDefaultForPropertyKey(HIBERNATE_CONNECTION_PASSWORD_PARAM, outputProperties);
        HibernateProperties.getDefaultForPropertyKey(DB_TABLE_NAME_PARAM, outputProperties);
        return outputProperties;
    }

    public static String getTableName(Properties setupProperties) {
        String appRecoveryPodTableName = setupProperties.getProperty(DB_TABLE_NAME_PARAM);
        if (appRecoveryPodTableName == null) {
            appRecoveryPodTableName = "RECOVERY_MARKER";
        }
        return appRecoveryPodTableName;
    }

    private static Optional<String> getProperty(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String property = System.getProperty(key);
        if (property == null) {
            property = System.getenv(key);
        }
        if (property == null) {
            property = System.getProperty(key.toLowerCase().replaceAll("_", "."));
        }
        if (property == null) {
            property = System.getenv(key.toUpperCase().replaceAll("[.]", "_"));
        }
        return Optional.ofNullable(property);
    }

    private static Optional<String> getDefaultForPropertyKey(String key, Properties propertiesToWriteIn) {
        Optional<String> value = HibernateProperties.getProperty(key);
        value.ifPresent(s -> propertiesToWriteIn.setProperty(key, (String)s));
        return value;
    }

    private static Properties setIfNotNull(String key, String value, Properties propertiesToChange) {
        if (key != null && value != null && !key.isEmpty() && !value.isEmpty()) {
            propertiesToChange.setProperty(key, value);
        }
        return propertiesToChange;
    }
}

