/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery.types;

public enum DatabaseType {
    POSTGRESQL("jdbc:postgresql:", "org.postgresql.Driver", "org.hibernate.dialect.PostgreSQLDialect", "jdbc:postgresql://{0}:{1,number,#}/{2}", "5432"),
    MYSQL("jdbc:mysql:", "com.mysql.jdbc.Driver", "org.hibernate.dialect.MySQLDialect", "jdbc:mysql://{0}:{1,number,#}/{2}", "3306"),
    ORACLE("jdbc:oracle:", "oracle.jdbc.driver.OracleDriver", "org.hibernate.dialect.OracleDialect", "jdbc:oracle:thin:@{0}:{1,number,#}:{2}", "1521"),
    DB2("jdbc:db2:", "com.ibm.db2.jcc.DB2Driver", "org.hibernate.dialect.DB2Dialect", "jdbc:db2://{0}:{1,number,#}/{2}", "50000"),
    MARIADB("jdbc:mariadb:", "org.mariadb.jdbc.Driver", "org.hibernate.dialect.MariaDBDialect", "jdbc:mariadb://{0}:{1,number,#}/{2}", "3306"),
    SYBASE("jdbc:sybase:", "com.sybase.jdbc4.jdbc.SybDriver", "org.hibernate.dialect.SybaseDialect", "jdbc:sybase:Tds:{0}:{1,number,#}/{2}", "5000"),
    MSSQL("jdbc:sqlserver:", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "org.hibernate.dialect.SQLServerDialect", "jdbc:sqlserver://{0}:{1,number,#};DatabaseName={2}", "1433"),
    POSTGRESPLUS("jdbc:edb:", "com.edb.Driver", "org.hibernate.dialect.PostgresPlusDialect", "jdbc:edb://{0}:{1,number,#}/{2}", "5432"),
    H2("jdbc:h2:", "org.h2.Driver", "org.hibernate.dialect.H2Dialect", "jdbc:h2:tcp://{0}:{1,number,#}/~/{2}", "8082"),
    UNKNOWN(null, null, null, null, null);

    private String dbNameMatch;
    private String jdbcUrlPattern;
    private String hibernateDialect;
    private String jdbcDriverClass;
    private String defaultPort;

    private DatabaseType(String dbNameMatch, String driverClass, String hibernateDialect, String jdbcUrlPattern, String defaultPort) {
        this.dbNameMatch = dbNameMatch;
        this.jdbcDriverClass = driverClass;
        this.hibernateDialect = hibernateDialect;
        this.jdbcUrlPattern = jdbcUrlPattern;
        this.defaultPort = defaultPort;
    }

    public String hibernateDialect() {
        return this.hibernateDialect;
    }

    public String port() {
        return this.defaultPort;
    }

    public String jdbcDriverClass() {
        return this.jdbcDriverClass;
    }

    public String jdbcUrlPattern() {
        return this.jdbcUrlPattern;
    }

    public static DatabaseType estimateType(String jdbcUrl) {
        if (jdbcUrl == null || jdbcUrl.isEmpty()) {
            return UNKNOWN;
        }
        if (jdbcUrl.contains(DatabaseType.POSTGRESPLUS.dbNameMatch)) {
            return POSTGRESPLUS;
        }
        if (jdbcUrl.contains(DatabaseType.POSTGRESQL.dbNameMatch)) {
            return POSTGRESQL;
        }
        if (jdbcUrl.contains(DatabaseType.MYSQL.dbNameMatch)) {
            return MYSQL;
        }
        if (jdbcUrl.contains(DatabaseType.MSSQL.dbNameMatch)) {
            return MSSQL;
        }
        if (jdbcUrl.contains(DatabaseType.MARIADB.dbNameMatch)) {
            return MARIADB;
        }
        if (jdbcUrl.contains(DatabaseType.ORACLE.dbNameMatch)) {
            return ORACLE;
        }
        if (jdbcUrl.contains(DatabaseType.DB2.dbNameMatch)) {
            return DB2;
        }
        if (jdbcUrl.contains(DatabaseType.SYBASE.dbNameMatch)) {
            return SYBASE;
        }
        if (jdbcUrl.contains(DatabaseType.H2.dbNameMatch)) {
            return H2;
        }
        return UNKNOWN;
    }
}

