/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery.cliargs;

import java.util.ArrayList;
import java.util.List;

class Options {
    List<OptionsData> optionData = new ArrayList<OptionsData>();

    Options() {
    }

    Options addOption(String shortName, String longName, boolean withArgument, String description) {
        OptionsData.add(this.optionData, shortName, longName, withArgument, description, false);
        return this;
    }

    Options addRequiredOption(String shortName, String longName, boolean withArgument, String description) {
        OptionsData.add(this.optionData, shortName, longName, withArgument, description, true);
        return this;
    }

    OptionsData getOption(String arg) {
        String adjustedArg = arg.trim().replaceFirst("^[-]*", "");
        for (OptionsData oneOptionData : this.optionData) {
            if (!adjustedArg.equals(oneOptionData.getShortName()) && !adjustedArg.equals(oneOptionData.getLongName())) continue;
            return oneOptionData;
        }
        return null;
    }

    List<OptionsData> getAllOptions() {
        return this.optionData;
    }

    void printHelpToStdErr() {
        for (OptionsData oneOptionData : this.optionData) {
            System.err.println(String.format("-%s/--%s : %s", oneOptionData.shortName, oneOptionData.longName, oneOptionData.description));
        }
    }

    static class OptionsData {
        String shortName;
        String longName;
        String description;
        boolean withArgument;
        boolean isRequired;
        String value;

        static void add(List<OptionsData> listToAddTo, String shortName, String longName, boolean withArgument, String description, boolean isRequired) {
            OptionsData od = new OptionsData(shortName, longName, withArgument, description, isRequired);
            listToAddTo.add(od);
        }

        private OptionsData(String shortName, String longName, boolean withArgument, String description, boolean isRequired) {
            this.shortName = shortName;
            this.longName = longName;
            this.withArgument = withArgument;
            this.description = description;
            this.isRequired = isRequired;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getLongName() {
            return this.longName;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isWithArgument() {
            return this.withArgument;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.shortName == null ? 0 : this.shortName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OptionsData other = (OptionsData)obj;
            return !(this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName));
        }

        public String toString() {
            return String.format("-%s/--%s : %s", this.shortName, this.longName, this.description);
        }
    }
}

