/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery;

import io.narayana.openshift.txrecovery.hibernate.ApplicationRecoveryPod;
import io.narayana.openshift.txrecovery.logging.I18NLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.jboss.logging.Logger;

public class ApplicationRecoveryPodHibernate5DAO {
    private static final Logger log = Logger.getLogger(ApplicationRecoveryPodHibernate5DAO.class);
    private Session session;

    public ApplicationRecoveryPodHibernate5DAO(Session session) {
        this.session = session;
    }

    public boolean saveRecord(String applicationPodName, String recoveryPodName) {
        this.session.getTransaction().begin();
        ApplicationRecoveryPod record = new ApplicationRecoveryPod(applicationPodName, recoveryPodName);
        try {
            this.session.persist((Object)record);
            this.session.getTransaction().commit();
        }
        catch (Exception e) {
            if (this.session.getTransaction() != null && this.session.getTransaction().getStatus() == TransactionStatus.ACTIVE) {
                this.session.getTransaction().rollback();
            }
            I18NLogger.logger.error_cannotPersistRecord(record, (Throwable)e);
            return false;
        }
        return true;
    }

    public int delete(String applicationPodName, String recoveryPodName) {
        String whereClause = "";
        if (applicationPodName != null && !applicationPodName.isEmpty()) {
            whereClause = whereClause + " where id.applicationPodName = :appPod";
        }
        if (recoveryPodName != null && !recoveryPodName.isEmpty()) {
            whereClause = whereClause + (whereClause.isEmpty() ? " where " : " and ");
            whereClause = whereClause + "id.recoveryPodName = :recPod";
        }
        String query = "delete from " + ApplicationRecoveryPod.class.getSimpleName() + whereClause;
        log.debugf("Query to be executed: %s", (Object)query);
        this.session.getTransaction().begin();
        Query q = this.session.createQuery(query);
        if (applicationPodName != null && !applicationPodName.isEmpty()) {
            q.setString("appPod", applicationPodName);
        }
        if (recoveryPodName != null && !recoveryPodName.isEmpty()) {
            q.setString("recPod", recoveryPodName);
        }
        int numberDeletedRecords = q.executeUpdate();
        this.session.getTransaction().commit();
        return numberDeletedRecords;
    }

    public boolean deleteRecord(ApplicationRecoveryPod recordDto) {
        if (recordDto == null) {
            return false;
        }
        this.session.getTransaction().begin();
        try {
            this.session.delete((Object)recordDto);
            this.session.getTransaction().commit();
        }
        catch (Exception e) {
            if (this.session.getTransaction() != null && this.session.getTransaction().getStatus() == TransactionStatus.ACTIVE) {
                this.session.getTransaction().rollback();
            }
            I18NLogger.logger.error_cannotRemoveRecord(recordDto, (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean tableExists(final String tableName) {
        try {
            return (Boolean)this.session.doReturningWork((ReturningWork)new ReturningWork<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Boolean execute(Connection connection) throws SQLException {
                    ResultSet tables = connection.getMetaData().getTables(null, null, tableName, null);
                    boolean isCaseSensitive = connection.getMetaData().supportsMixedCaseIdentifiers();
                    try {
                        block9: {
                            while (tables.next()) {
                                String currentTableName = tables.getString("TABLE_NAME");
                                if (isCaseSensitive) {
                                    if (!currentTableName.equals(tableName)) continue;
                                    Boolean bl = true;
                                    return bl;
                                }
                                if (!currentTableName.equalsIgnoreCase(tableName)) {
                                    continue;
                                }
                                break block9;
                            }
                            return false;
                        }
                        Boolean bl = true;
                        return bl;
                    }
                    finally {
                        if (tables != null) {
                            tables.close();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            I18NLogger.logger.error_dbTableDoesNotExist(tableName, (Throwable)e);
            return false;
        }
    }

    public Collection<ApplicationRecoveryPod> getRecords(String applicationPodName, String recoveryPodName) {
        Criteria criteria = this.session.createCriteria(ApplicationRecoveryPod.class);
        if (applicationPodName != null && !applicationPodName.isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"id.applicationPodName", (Object)applicationPodName));
        }
        if (recoveryPodName != null && !recoveryPodName.isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"id.recoveryPodName", (Object)recoveryPodName));
        }
        return criteria.list();
    }
}

