/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.openshift.txrecovery;

import io.narayana.openshift.txrecovery.hibernate.ApplicationRecoveryPod;
import io.narayana.openshift.txrecovery.hibernate.HibernateProperties;
import io.narayana.openshift.txrecovery.logging.I18NLogger;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;

public final class Hibernate5Setup {
    private Hibernate5Setup() {
    }

    public static StandardServiceRegistry getStandardRegistry(Properties setupProperties) {
        StandardServiceRegistryBuilder standardRegistryBuilder = new StandardServiceRegistryBuilder();
        standardRegistryBuilder.applySettings((Map)setupProperties);
        return standardRegistryBuilder.build();
    }

    public static Metadata getHibernateStartupMetadata(Properties setupProperties, ServiceRegistry standardRegistry) {
        final String programParamTableName = HibernateProperties.getTableName((Properties)setupProperties);
        MetadataSources sources = new MetadataSources(standardRegistry).addAnnotatedClass(ApplicationRecoveryPod.class);
        MetadataBuilder metadataBuilder = sources.getMetadataBuilder();
        metadataBuilder.applyPhysicalNamingStrategy((PhysicalNamingStrategy)new PhysicalNamingStrategyStandardImpl(){
            private static final long serialVersionUID = 1L;

            public Identifier toPhysicalTableName(Identifier originalTableName, JdbcEnvironment jdbcEnvironment) {
                if (originalTableName.getCanonicalName().equalsIgnoreCase("RECOVERY_MARKER") && programParamTableName != null && !programParamTableName.isEmpty()) {
                    return Identifier.toIdentifier((String)programParamTableName);
                }
                return originalTableName;
            }
        });
        return metadataBuilder.build();
    }

    public static boolean createTable(Metadata metadata) {
        SchemaExport schemaExport = new SchemaExport();
        schemaExport.createOnly(EnumSet.of(TargetType.DATABASE), metadata);
        if (schemaExport.getExceptions() != null && !schemaExport.getExceptions().isEmpty()) {
            I18NLogger.logger.error_schemaExportFailure(schemaExport.getExceptions());
            return false;
        }
        return true;
    }

    public static void close(SessionFactory sf, Session s) {
        if (s.isOpen()) {
            s.close();
        }
        if (!sf.isClosed()) {
            sf.close();
        }
    }
}

