/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.sfn.deployment;

import io.quarkiverse.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuilderInstanceBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientInjectionBuildItem;
import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.HasTransportBuildTimeConfig;
import io.quarkiverse.amazon.sfn.runtime.SfnBuildTimeConfig;
import io.quarkiverse.amazon.sfn.runtime.SfnRecorder;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.sfn.SfnAsyncClient;
import software.amazon.awssdk.services.sfn.SfnAsyncClientBuilder;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.SfnClientBuilder;

public class SfnProcessor
extends AbstractAmazonServiceProcessor {
    private static final String AMAZON_CLIENT_NAME = "amazon-sdk-sfn";
    SfnBuildTimeConfig buildTimeConfig;

    protected String amazonServiceClientName() {
        return AMAZON_CLIENT_NAME;
    }

    protected String configName() {
        return "sfn";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)SfnClient.class.getName());
    }

    protected Class<?> syncClientBuilderClass() {
        return SfnClientBuilder.class;
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)SfnAsyncClient.class.getName());
    }

    protected Class<?> asyncClientBuilderClass() {
        return SfnAsyncClientBuilder.class;
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/sfn/execution.interceptors";
    }

    protected HasTransportBuildTimeConfig transportBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    protected HasSdkBuildTimeConfig sdkBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBuilders(SfnRecorder recorder, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, BuildProducer<AmazonClientExtensionBuilderInstanceBuildItem> builderInstances) {
        this.createExtensionBuilders((AmazonClientRecorder)recorder, amazonClientInjections, builderInstances);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setup(SfnRecorder recorder, BuildProducer<AmazonClientExtensionBuildItem> amazonExtensions) {
        this.setupExtension((AmazonClientRecorder)recorder, amazonExtensions);
    }
}

