/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.sns.runtime;

import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.HasAmazonClientRuntimeConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkiverse.amazon.sns.runtime.SnsConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.SnsAsyncClientBuilder;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;

@Recorder
public class SnsRecorder
extends AmazonClientRecorder {
    final RuntimeValue<SnsConfig> config;

    public SnsRecorder(RuntimeValue<SnsConfig> config) {
        this.config = config;
    }

    public RuntimeValue<? extends HasAmazonClientRuntimeConfig> getAmazonClientsConfig() {
        return this.config;
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return ((SnsConfig)this.config.getValue()).asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return ((SnsConfig)this.config.getValue()).syncClient();
    }

    public AwsSyncClientBuilder<?, ?> getSyncClientBuilder() {
        SnsClientBuilder builder = SnsClient.builder();
        return builder;
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        SnsAsyncClientBuilder builder = SnsAsyncClient.builder();
        return builder;
    }
}

