/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.sqs.runtime;

import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import io.quarkus.amazon.common.runtime.AmazonClientOpenTelemetryRecorder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.net.URI;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

@Recorder
public class SqsOpenTelemetryRecorder
extends AmazonClientOpenTelemetryRecorder {
    protected AwsClientBuilder wrapSyncClientBuilder(AwsClientBuilder clientBuilder, RuntimeValue<AwsSdkTelemetry> awsSdkTelemetry) {
        return new TelemetryEnabledSqsSyncClientBuilder((SqsClientBuilder)clientBuilder, (AwsSdkTelemetry)awsSdkTelemetry.getValue());
    }

    protected AwsClientBuilder wrapAsyncClientBuilder(AwsClientBuilder clientBuilder, RuntimeValue<AwsSdkTelemetry> awsSdkTelemetry) {
        return new TelemetryEnabledSqsAsyncClientBuilder((SqsAsyncClientBuilder)clientBuilder, (AwsSdkTelemetry)awsSdkTelemetry.getValue());
    }

    private final class TelemetryEnabledSqsSyncClientBuilder
    implements SqsClientBuilder {
        private SqsClientBuilder baseBuilder;
        private AwsSdkTelemetry awsSdkTelemetry;

        public TelemetryEnabledSqsSyncClientBuilder(SqsClientBuilder baseBuilder, AwsSdkTelemetry awsSdkTelemetry) {
            this.baseBuilder = baseBuilder;
            this.awsSdkTelemetry = awsSdkTelemetry;
        }

        public SqsClientBuilder httpClient(SdkHttpClient httpClient) {
            return (SqsClientBuilder)this.baseBuilder.httpClient(httpClient);
        }

        public SqsClientBuilder httpClientBuilder(SdkHttpClient.Builder httpClientBuilder) {
            return (SqsClientBuilder)this.baseBuilder.httpClientBuilder(httpClientBuilder);
        }

        public SqsClientBuilder region(Region region) {
            return (SqsClientBuilder)this.baseBuilder.region(region);
        }

        public SqsClientBuilder checksumValidationEnabled(Boolean checksumValidationEnabled) {
            return (SqsClientBuilder)this.baseBuilder.checksumValidationEnabled(checksumValidationEnabled);
        }

        public SqsClientBuilder dualstackEnabled(Boolean dualstackEndpointEnabled) {
            return (SqsClientBuilder)this.baseBuilder.dualstackEnabled(dualstackEndpointEnabled);
        }

        public SqsClientBuilder fipsEnabled(Boolean fipsEndpointEnabled) {
            return (SqsClientBuilder)this.baseBuilder.fipsEnabled(fipsEndpointEnabled);
        }

        public SqsClientBuilder overrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
            return (SqsClientBuilder)this.baseBuilder.overrideConfiguration(overrideConfiguration);
        }

        public ClientOverrideConfiguration overrideConfiguration() {
            return this.baseBuilder.overrideConfiguration();
        }

        public SqsClientBuilder endpointOverride(URI endpointOverride) {
            return (SqsClientBuilder)this.baseBuilder.endpointOverride(endpointOverride);
        }

        public SqsClient build() {
            return this.awsSdkTelemetry.wrap((SqsClient)this.baseBuilder.build());
        }
    }

    private final class TelemetryEnabledSqsAsyncClientBuilder
    implements SqsAsyncClientBuilder {
        private SqsAsyncClientBuilder baseBuilder;
        private AwsSdkTelemetry awsSdkTelemetry;

        public TelemetryEnabledSqsAsyncClientBuilder(SqsAsyncClientBuilder baseBuilder, AwsSdkTelemetry awsSdkTelemetry) {
            this.baseBuilder = baseBuilder;
            this.awsSdkTelemetry = awsSdkTelemetry;
        }

        public SqsAsyncClientBuilder asyncConfiguration(ClientAsyncConfiguration clientAsyncConfiguration) {
            return (SqsAsyncClientBuilder)this.baseBuilder.asyncConfiguration(clientAsyncConfiguration);
        }

        public SqsAsyncClientBuilder httpClient(SdkAsyncHttpClient httpClient) {
            return (SqsAsyncClientBuilder)this.baseBuilder.httpClient(httpClient);
        }

        public SqsAsyncClientBuilder httpClientBuilder(SdkAsyncHttpClient.Builder httpClientBuilder) {
            return (SqsAsyncClientBuilder)this.baseBuilder.httpClientBuilder(httpClientBuilder);
        }

        public SqsAsyncClientBuilder checksumValidationEnabled(Boolean checksumValidationEnabled) {
            return (SqsAsyncClientBuilder)this.baseBuilder.checksumValidationEnabled(checksumValidationEnabled);
        }

        public SqsAsyncClientBuilder region(Region region) {
            return (SqsAsyncClientBuilder)this.baseBuilder.region(region);
        }

        public SqsAsyncClientBuilder dualstackEnabled(Boolean dualstackEndpointEnabled) {
            return (SqsAsyncClientBuilder)this.baseBuilder.dualstackEnabled(dualstackEndpointEnabled);
        }

        public SqsAsyncClientBuilder fipsEnabled(Boolean fipsEndpointEnabled) {
            return (SqsAsyncClientBuilder)this.baseBuilder.fipsEnabled(fipsEndpointEnabled);
        }

        public SqsAsyncClientBuilder overrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
            return (SqsAsyncClientBuilder)this.baseBuilder.overrideConfiguration(overrideConfiguration);
        }

        public ClientOverrideConfiguration overrideConfiguration() {
            return this.baseBuilder.overrideConfiguration();
        }

        public SqsAsyncClientBuilder endpointOverride(URI endpointOverride) {
            return (SqsAsyncClientBuilder)this.baseBuilder.endpointOverride(endpointOverride);
        }

        public SqsAsyncClient build() {
            return this.awsSdkTelemetry.wrap((SqsAsyncClient)this.baseBuilder.build());
        }
    }
}

