/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.sqs.runtime;

import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkiverse.amazon.sqs.runtime.SqsConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsClient;

@Recorder
public class SqsRecorder
extends AmazonClientRecorder {
    final RuntimeValue<SqsConfig> config;

    public SqsRecorder(RuntimeValue<SqsConfig> config) {
        this.config = config;
    }

    public RuntimeValue<SqsConfig> getAmazonClientsConfig() {
        return this.config;
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return ((SqsConfig)this.config.getValue()).asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return ((SqsConfig)this.config.getValue()).syncClient();
    }

    public AwsSyncClientBuilder<?, ?> getSyncClientBuilder() {
        return SqsClient.builder();
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        return SqsAsyncClient.builder();
    }
}

