/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.consul.config.runtime;

import io.quarkus.consul.config.runtime.ConsulConfig;
import io.quarkus.consul.config.runtime.ConsulConfigGateway;
import io.quarkus.consul.config.runtime.Response;
import io.quarkus.consul.config.runtime.ResponseConfigSourceUtil;
import io.quarkus.consul.config.runtime.ValueType;
import io.quarkus.consul.config.runtime.VertxConsulConfigGateway;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniAwait;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

class ConsulConfigSourceFactory
implements ConfigSourceFactory.ConfigurableConfigSourceFactory<ConsulConfig> {
    private static final Logger log = Logger.getLogger(ConsulConfigSourceFactory.class);

    ConsulConfigSourceFactory() {
    }

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context, ConsulConfig config) {
        if (!config.enabled()) {
            return Collections.emptyList();
        }
        return this.getConfigSources(config, new VertxConsulConfigGateway(config));
    }

    Iterable<ConfigSource> getConfigSources(final ConsulConfig config, ConsulConfigGateway consulConfigGateway) {
        LinkedHashMap<String, ValueType> keys = new LinkedHashMap<String, ValueType>();
        if (config.rawValueKeys().isPresent()) {
            for (String key : config.rawValueKeys().get()) {
                keys.put(key, ValueType.RAW);
            }
        }
        if (config.propertiesValueKeys().isPresent()) {
            for (String key : config.propertiesValueKeys().get()) {
                keys.put(key, ValueType.PROPERTIES);
            }
        }
        if (keys.isEmpty()) {
            log.debug((Object)"No keys were configured for config source lookup");
            return Collections.emptyList();
        }
        final LinkedHashMap results = new LinkedHashMap(keys.size());
        ArrayList<Uni> allUnis = new ArrayList<Uni>();
        for (final Map.Entry entry : keys.entrySet()) {
            final String fullKey = config.prefix().isPresent() ? config.prefix().get() + "/" + (String)entry.getKey() : (String)entry.getKey();
            results.put(fullKey, null);
            allUnis.add(consulConfigGateway.getValue(fullKey).invoke((Consumer)new Consumer<Response>(){

                @Override
                public void accept(Response response) {
                    if (response != null) {
                        results.put(response.getKey(), ResponseConfigSourceUtil.toConfigSource(response, (ValueType)((Object)entry.getValue()), config.prefix()));
                    } else {
                        String message = "Key '" + fullKey + "' not found in Consul.";
                        if (config.failOnMissingKey()) {
                            throw new RuntimeException(message);
                        }
                        results.remove(fullKey);
                        log.info((Object)message);
                    }
                }
            }));
        }
        try {
            UniAwait await = Uni.combine().all().unis(allUnis).discardItems().await();
            if (config.agent().connectionTimeout().isZero() && config.agent().readTimeout().isZero()) {
                await.indefinitely();
            } else {
                await.atMost(config.agent().connectionTimeout().plus(config.agent().readTimeout().multipliedBy(2L)));
            }
        }
        catch (CompletionException e) {
            throw new RuntimeException("An error occurred while attempting to fetch configuration from Consul.", e);
        }
        finally {
            consulConfigGateway.close();
        }
        return results.values();
    }
}

