/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client;

import io.quarkiverse.minio.client.MinioBuildTimeConfiguration;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithParentName;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

@ConfigMapping(prefix="quarkus.minio")
@ConfigRoot(phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public interface MiniosBuildTimeConfiguration {
    public static final String DEFAULT_MINIOCLIENT_NAME = "<default>";

    @WithParentName
    public MinioBuildTimeConfiguration minio();

    @WithParentName
    public Map<String, MinioBuildTimeConfiguration> namedMinioClients();

    default public Map<String, MinioBuildTimeConfiguration> getMinioClients() {
        HashMap<String, MinioBuildTimeConfiguration> minioClients = new HashMap<String, MinioBuildTimeConfiguration>();
        if (this.minio() != null && this.minio().enabled()) {
            minioClients.put(DEFAULT_MINIOCLIENT_NAME, this.minio());
        }
        minioClients.putAll(this.namedMinioClients().entrySet().stream().filter(entry -> ((MinioBuildTimeConfiguration)entry.getValue()).enabled()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return minioClients;
    }

    public static boolean isDefault(String minioClientName) {
        return DEFAULT_MINIOCLIENT_NAME.equals(minioClientName);
    }
}

