/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservice.runtime.config;

import io.quarkus.devservices.crossclassloader.runtime.RunningDevServicesRegistry;
import io.quarkus.devservices.crossclassloader.runtime.RunningService;
import io.quarkus.runtime.LaunchMode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class DevServicesConfigSource
implements ConfigSource {
    private final LaunchMode launchMode;

    public DevServicesConfigSource(LaunchMode launchMode) {
        this.launchMode = launchMode;
    }

    public Set<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        Set allConfig = RunningDevServicesRegistry.INSTANCE.getAllRunningServices(this.launchMode.name());
        if (allConfig != null) {
            for (RunningService service : allConfig) {
                Map config = service.configs();
                names.addAll(config.keySet());
            }
        }
        return names;
    }

    public String getValue(String propertyName) {
        Set allConfig = RunningDevServicesRegistry.INSTANCE.getAllRunningServices(this.launchMode.name());
        if (allConfig != null) {
            for (RunningService service : allConfig) {
                Map config = service.configs();
                String answer = (String)config.get(propertyName);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    public String getName() {
        return "DevServicesConfigSource";
    }

    public int getOrdinal() {
        return 10;
    }
}

