/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core.strategy;

import io.quarkus.devtools.codestarts.CodestartStructureException;
import io.quarkus.devtools.codestarts.core.reader.TargetFile;
import io.quarkus.devtools.codestarts.core.strategy.CodestartFileStrategyHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DockerComposeCodestartFileStrategyHandler
implements CodestartFileStrategyHandler {
    static final String NAME = "docker-compose-includes";
    final String INCLUDE_LINE_IDENTIFIER = "include:\n";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<TargetFile> codestartFiles, Map<String, Object> data) throws IOException {
        List includes = data.getOrDefault(NAME, new ArrayList());
        for (TargetFile targetFile : codestartFiles) {
            String filename = targetFile.getSourceName();
            this.writeFile(targetDirectory.resolve(filename), targetFile.getContent());
            includes.add(filename);
        }
        data.put(NAME, includes);
        StringBuilder content = new StringBuilder("include:\n");
        for (String include : includes) {
            content.append("  - ").append(include).append("\n");
        }
        Path path = targetDirectory.resolve("docker-compose.yml");
        this.writeFile(path, content.toString());
    }

    @Override
    public void writeFile(Path targetPath, String content) throws IOException {
        if (Files.exists(targetPath, new LinkOption[0]) && !Files.readString(targetPath).startsWith("include:\n")) {
            throw new CodestartStructureException("Target file already exists: " + targetPath.toString());
        }
        Files.writeString(targetPath, (CharSequence)content, new OpenOption[0]);
    }
}

