/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.junit.DisableIfBuiltWithGraalVMOlderThanCondition;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.jupiter.api.extension.ExtendWith;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@ExtendWith(value={DisableIfBuiltWithGraalVMOlderThanCondition.class})
public @interface DisableIfBuiltWithGraalVMOlderThan {
    public GraalVMVersion value();

    public static enum GraalVMVersion {
        GRAALVM_21_0(21, 0);

        private final int major;
        private final int minor;

        private GraalVMVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int compareTo(int major, int minor) {
            int majorComparison = Integer.compare(this.major, major);
            if (majorComparison != 0) {
                return majorComparison;
            }
            return Integer.compare(this.minor, minor);
        }

        public String toString() {
            return "GraalVMVersion{major=" + this.major + ", minor=" + this.minor + "}";
        }
    }
}

