/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.nativeimage;

import io.quarkus.deployment.pkg.steps.GraalVM;
import io.quarkus.test.junit.IntegrationTestUtil;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

@Deprecated
public class NativeBuildOutputExtension
implements BeforeAllCallback {
    private static final String IMAGE_METRICS_TEST_PROPERTIES = "image-metrics.properties";
    private static final String IMAGE_METRICS_DIR = "image-metrics";
    private final JsonObject buildOutput = NativeBuildOutputExtension.getBuildOutput();
    private static GraalVM.Version mandrelVersion;

    public void verifyImageMetrics() {
        String version = mandrelVersion.getMajorMinorAsString();
        String propertiesFileName = "image-metrics/" + version + "/image-metrics.properties";
        this.verifyImageMetrics(propertiesFileName);
    }

    public void verifyImageMetrics(String propertiesFileName) {
        boolean skipVerifyImageMetrics = Boolean.parseBoolean(System.getenv("QUARKUS_NATIVE_IT_SKIP_VERIFY_IMAGE_METRICS"));
        Assumptions.assumeFalse((boolean)skipVerifyImageMetrics, (String)"Environment variable QUARKUS_NATIVE_IT_SKIP_VERIFY_IMAGE_METRICS is set. Skipping image metrics verification.");
        Properties properties = this.getProperties(propertiesFileName);
        Assertions.assertAll(properties.entrySet().stream().map(entry -> () -> {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.endsWith(".tolerance")) {
                return;
            }
            String[] keyParts = key.split("\\.");
            String tolerance = properties.getProperty(key + ".tolerance");
            assert (tolerance != null) : "tolerance not defined for " + key;
            this.assertValueWithinRange(Integer.parseInt(value), Integer.parseInt(tolerance), keyParts);
        }));
    }

    private Properties getProperties(String propertiesFileName) {
        Properties properties = new Properties();
        try {
            InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(propertiesFileName);
            Assumptions.assumeTrue((resourceAsStream != null ? 1 : 0) != 0, (String)("Could not find properties file matching the Mandrel version being used: " + propertiesFileName));
            properties.load(resourceAsStream);
        }
        catch (IOException e) {
            Assertions.fail((String)("Could not load properties from " + propertiesFileName), (Throwable)e);
        }
        return properties;
    }

    private void assertValueWithinRange(int expectedValue, int tolerancePercentage, String ... key) {
        JsonObject currentObject = this.buildOutput;
        for (int i = 0; i < key.length - 1; ++i) {
            currentObject = currentObject.getJsonObject(key[i]);
        }
        String lastKey = key[key.length - 1];
        int actualValue = currentObject.getInt(lastKey);
        Assertions.assertTrue((boolean)this.isNumberWithinRange(expectedValue, actualValue, tolerancePercentage), (String)("Expected " + String.join((CharSequence)".", key) + " to be within range [" + expectedValue + " +- " + tolerancePercentage + "%] but was " + actualValue));
    }

    private boolean isNumberWithinRange(int expectedNumberOfClasses, int actualNumberOfClasses, int tolerancePercentage) {
        int lowerBound = expectedNumberOfClasses - expectedNumberOfClasses * tolerancePercentage / 100;
        int upperBound = expectedNumberOfClasses + expectedNumberOfClasses * tolerancePercentage / 100;
        return actualNumberOfClasses >= lowerBound && actualNumberOfClasses <= upperBound;
    }

    private static JsonObject getBuildOutput() {
        JsonObject jsonObject;
        block8: {
            Path buildOutputPath = NativeBuildOutputExtension.getBuildOutputPath();
            InputStream inputStream = Files.newInputStream(buildOutputPath, new OpenOption[0]);
            try {
                jsonObject = Json.createReader((InputStream)inputStream).readObject();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not load build output", e);
                }
            }
            inputStream.close();
        }
        return jsonObject;
    }

    private static Path getBuildOutputPath() {
        Path buildDirectory = NativeBuildOutputExtension.locateNativeImageBuildDirectory();
        File[] buildOutput = buildDirectory.toFile().listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith("-build-output-stats.json"));
        Assertions.assertNotNull((Object)buildOutput, (String)"Could not identify the native image build output");
        Assertions.assertEquals((int)1, (int)buildOutput.length, (String)"Could not identify the native image build output");
        return buildOutput[0].toPath();
    }

    private static Path locateNativeImageBuildDirectory() {
        Path buildPath = Paths.get("target", new String[0]);
        File[] files = buildPath.toFile().listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith("-native-image-source-jar"));
        Assertions.assertNotNull((Object)files, (String)"Could not identify the native image build directory");
        Assertions.assertEquals((int)1, (int)files.length, (String)"Could not identify the native image build directory");
        return files[0].toPath();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        mandrelVersion = this.getMandrelVersion(extensionContext);
    }

    private GraalVM.Version getMandrelVersion(ExtensionContext context) {
        Properties quarkusArtifactProperties = IntegrationTestUtil.readQuarkusArtifactProperties(context);
        String fullVersion = quarkusArtifactProperties.getProperty("metadata.graalvm.version.full");
        try {
            return GraalVM.Version.of(fullVersion.lines());
        }
        catch (NumberFormatException e) {
            System.out.println("WARNING: Unable to determine the GraalVM version with which the native binary was built. metadata.graalvm.version.full = " + fullVersion);
            return GraalVM.Version.CURRENT;
        }
    }
}

