/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.config.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.RunTimeConfigurationSourceValueBuildItem;
import io.quarkus.kubernetes.client.runtime.KubernetesClientBuildConfig;
import io.quarkus.kubernetes.config.runtime.KubernetesConfigBuildTimeConfig;
import io.quarkus.kubernetes.config.runtime.KubernetesConfigRecorder;
import io.quarkus.kubernetes.config.runtime.KubernetesConfigSourceConfig;
import io.quarkus.kubernetes.config.runtime.SecretsRoleConfig;
import io.quarkus.kubernetes.spi.KubernetesClusterRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesServiceAccountBuildItem;
import io.quarkus.kubernetes.spi.PolicyRule;
import io.quarkus.runtime.TlsConfig;
import java.util.List;

public class KubernetesConfigProcessor {
    private static final String ANY_TARGET = null;
    private static final List<PolicyRule> POLICY_RULE_FOR_ROLE = List.of(new PolicyRule(List.of(""), List.of("secrets"), List.of("get")));

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public RunTimeConfigurationSourceValueBuildItem configure(KubernetesConfigRecorder recorder, KubernetesConfigSourceConfig config, KubernetesConfigBuildTimeConfig buildTimeConfig, KubernetesClientBuildConfig clientConfig, TlsConfig tlsConfig) {
        return new RunTimeConfigurationSourceValueBuildItem(recorder.configSources(config, buildTimeConfig, clientConfig, tlsConfig));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void handleAccessToSecrets(KubernetesConfigSourceConfig config, KubernetesConfigBuildTimeConfig buildTimeConfig, BuildProducer<KubernetesRoleBuildItem> roleProducer, BuildProducer<KubernetesClusterRoleBuildItem> clusterRoleProducer, BuildProducer<KubernetesServiceAccountBuildItem> serviceAccountProducer, BuildProducer<KubernetesRoleBindingBuildItem> roleBindingProducer, KubernetesConfigRecorder recorder) {
        if (buildTimeConfig.secretsEnabled) {
            SecretsRoleConfig roleConfig = buildTimeConfig.secretsRoleConfig;
            String roleName = roleConfig.name;
            if (roleConfig.generate) {
                if (roleConfig.clusterWide) {
                    clusterRoleProducer.produce((BuildItem)new KubernetesClusterRoleBuildItem(roleName, POLICY_RULE_FOR_ROLE, ANY_TARGET));
                } else {
                    roleProducer.produce((BuildItem)new KubernetesRoleBuildItem(roleName, (String)roleConfig.namespace.orElse(null), POLICY_RULE_FOR_ROLE, ANY_TARGET));
                }
            }
            serviceAccountProducer.produce((BuildItem)new KubernetesServiceAccountBuildItem(true));
            roleBindingProducer.produce((BuildItem)new KubernetesRoleBindingBuildItem(roleName, roleConfig.clusterWide));
        }
        recorder.warnAboutSecrets(config, buildTimeConfig);
    }
}

