/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.restclient.config.RegisteredRestClient;
import io.quarkus.restclient.config.RestClientNameFallbackConfigSourceInterceptor;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.List;

public abstract class AbstractRestClientConfigBuilder
implements ConfigBuilder {
    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        List<RegisteredRestClient> restClients = this.getRestClients();
        builder.withInterceptors(new ConfigSourceInterceptor[]{new RestClientNameFallbackConfigSourceInterceptor(restClients)});
        for (RegisteredRestClient restClient : restClients) {
            builder.withDefaultValue("quarkus.rest-client.\"" + restClient.getFullName() + "\".force", "true");
            builder.withDefaultValue("quarkus.rest-client." + restClient.getSimpleName() + ".force", "true");
            if (restClient.getConfigKey() == null) continue;
            builder.withDefaultValue("quarkus.rest-client." + restClient.getConfigKey() + ".force", "true");
        }
        return builder;
    }

    public abstract List<RegisteredRestClient> getRestClients();
}

