/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment.filter;

import io.quarkus.smallrye.openapi.deployment.filter.ClassAndMethod;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

public class OperationFilter
implements OASFilter {
    public static final String EXT_METHOD_REF = "x-quarkus-openapi-method-ref";
    private final Map<String, ClassAndMethod> classNameMap;
    private final Map<String, List<String>> rolesAllowedMethodReferences;
    private final List<String> authenticatedMethodReferences;
    private final String defaultSecuritySchemeName;
    private final boolean doAutoTag;
    private final boolean doAutoOperation;
    private final boolean alwaysIncludeScopesValidForScheme;

    public OperationFilter(Map<String, ClassAndMethod> classNameMap, Map<String, List<String>> rolesAllowedMethodReferences, List<String> authenticatedMethodReferences, String defaultSecuritySchemeName, boolean doAutoTag, boolean doAutoOperation, boolean alwaysIncludeScopesValidForScheme) {
        this.classNameMap = Objects.requireNonNull(classNameMap);
        this.rolesAllowedMethodReferences = Objects.requireNonNull(rolesAllowedMethodReferences);
        this.authenticatedMethodReferences = Objects.requireNonNull(authenticatedMethodReferences);
        this.defaultSecuritySchemeName = Objects.requireNonNull(defaultSecuritySchemeName);
        this.doAutoTag = doAutoTag;
        this.doAutoOperation = doAutoOperation;
        this.alwaysIncludeScopesValidForScheme = alwaysIncludeScopesValidForScheme;
    }

    /*
     * Unable to fully structure code
     */
    public void filterOpenAPI(OpenAPI openAPI) {
        securityScheme = this.getSecurityScheme(openAPI);
        schemeName = securityScheme.map((Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getKey(), (Ljava/util/Map$Entry;)Ljava/lang/String;)()).orElse(this.defaultSecuritySchemeName);
        if (this.alwaysIncludeScopesValidForScheme) ** GOTO lbl-1000
        if (securityScheme.map((Function<Map.Entry, SecurityScheme>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Ljava/util/Map$Entry;)Lorg/eclipse/microprofile/openapi/models/security/SecurityScheme;)()).map((Function<SecurityScheme, SecurityScheme.Type>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getType(), (Lorg/eclipse/microprofile/openapi/models/security/SecurityScheme;)Lorg/eclipse/microprofile/openapi/models/security/SecurityScheme$Type;)()).map((Function<SecurityScheme.Type, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, contains(java.lang.Object ), (Lorg/eclipse/microprofile/openapi/models/security/SecurityScheme$Type;)Ljava/lang/Boolean;)(Set.of(SecurityScheme.Type.OAUTH2, SecurityScheme.Type.OPENIDCONNECT))).orElse(false).booleanValue()) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        scopesValidForScheme = v0;
        defaultSecurityErrors = this.getSecurityResponses();
        Optional.ofNullable(openAPI.getPaths()).map((Function<Paths, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPathItems(), (Lorg/eclipse/microprofile/openapi/models/Paths;)Ljava/util/Map;)()).map((Function<Map, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, entrySet(), (Ljava/util/Map;)Ljava/util/Set;)()).map((Function<Set, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/Set;)Ljava/util/stream/Stream;)()).orElseGet((Supplier<Stream>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, empty(), ()Ljava/util/stream/Stream;)()).map((Function<Map.Entry, PathItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Ljava/util/Map$Entry;)Lorg/eclipse/microprofile/openapi/models/PathItem;)()).map((Function<PathItem, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getOperations(), (Lorg/eclipse/microprofile/openapi/models/PathItem;)Ljava/util/Map;)()).filter((Predicate<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Ljava/util/Map;)Z)()).map((Function<Map, Collection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, values(), (Ljava/util/Map;)Ljava/util/Collection;)()).flatMap((Function<Collection, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/Collection;)Ljava/util/stream/Stream;)()).forEach((Consumer<Operation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$filterOpenAPI$0(java.lang.String boolean java.util.Map org.eclipse.microprofile.openapi.models.Operation ), (Lorg/eclipse/microprofile/openapi/models/Operation;)V)((OperationFilter)this, (String)schemeName, (boolean)scopesValidForScheme, defaultSecurityErrors));
    }

    private String methodRef(Operation operation) {
        Map extensions = operation.getExtensions();
        return extensions != null ? extensions.get(EXT_METHOD_REF) : null;
    }

    private void maybeSetSummaryAndTag(Operation operation, String methodRef) {
        if (!this.classNameMap.containsKey(methodRef)) {
            return;
        }
        ClassAndMethod classMethod = this.classNameMap.get(methodRef);
        if (this.doAutoOperation && operation.getSummary() == null) {
            operation.setSummary(this.capitalizeFirstLetter(this.splitCamelCase(classMethod.methodName())));
        }
        if (this.doAutoTag && (operation.getTags() == null || operation.getTags().isEmpty())) {
            operation.addTag(this.splitCamelCase(classMethod.className()));
        }
    }

    private String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    private String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private void maybeAddSecurityRequirement(Operation operation, String methodRef, String schemeName, boolean allowScopes, Map<String, APIResponse> defaultSecurityErrors) {
        if (this.rolesAllowedMethodReferences.containsKey(methodRef)) {
            List<String> scopes = this.rolesAllowedMethodReferences.get(methodRef);
            this.addSecurityRequirement(operation, schemeName, allowScopes ? scopes : Collections.emptyList());
            this.addDefaultSecurityResponses(operation, defaultSecurityErrors);
        } else if (this.authenticatedMethodReferences.contains(methodRef)) {
            this.addSecurityRequirement(operation, schemeName, Collections.emptyList());
            this.addDefaultSecurityResponses(operation, defaultSecurityErrors);
        }
    }

    private Optional<Map.Entry<String, SecurityScheme>> getSecurityScheme(OpenAPI openAPI) {
        return Optional.ofNullable(openAPI.getComponents()).map(Components::getSecuritySchemes).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).findFirst();
    }

    private void addSecurityRequirement(Operation operation, String schemeName, List<String> scopes) {
        SecurityRequirement securityRequirement = OASFactory.createSecurityRequirement();
        securityRequirement = securityRequirement.addScheme(schemeName, scopes);
        operation.addSecurityRequirement(securityRequirement);
    }

    private void addDefaultSecurityResponses(Operation operation, Map<String, APIResponse> defaultSecurityErrors) {
        APIResponses responses = operation.getResponses();
        defaultSecurityErrors.entrySet().stream().filter(e -> !responses.hasAPIResponse((String)e.getKey())).forEach(e -> responses.addAPIResponse((String)e.getKey(), (APIResponse)e.getValue()));
    }

    private Map<String, APIResponse> getSecurityResponses() {
        LinkedHashMap<String, APIResponse> responses = new LinkedHashMap<String, APIResponse>();
        responses.put("401", OASFactory.createAPIResponse().description("Not Authorized"));
        responses.put("403", OASFactory.createAPIResponse().description("Not Allowed"));
        return responses;
    }

    private /* synthetic */ void lambda$filterOpenAPI$0(String schemeName, boolean scopesValidForScheme, Map defaultSecurityErrors, Operation operation) {
        String methodRef = this.methodRef(operation);
        if (methodRef != null) {
            this.maybeSetSummaryAndTag(operation, methodRef);
            this.maybeAddSecurityRequirement(operation, methodRef, schemeName, scopesValidForScheme, defaultSecurityErrors);
        }
        operation.removeExtension(EXT_METHOD_REF);
    }
}

