/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.cdi;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Classes;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Cpu;
import io.opentelemetry.instrumentation.runtimemetrics.java8.GarbageCollector;
import io.opentelemetry.instrumentation.runtimemetrics.java8.MemoryPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Threads;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.smallrye.opentelemetry.api.OpenTelemetryBuilderGetter;
import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import io.smallrye.opentelemetry.api.OpenTelemetryHandler;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

@Singleton
public class OpenTelemetryProducer {
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    @Produces
    @Singleton
    public OpenTelemetry getOpenTelemetry(OpenTelemetryConfig config) {
        OpenTelemetrySdk openTelemetry = new OpenTelemetryBuilderGetter().apply(config).disableShutdownHook().build().getOpenTelemetrySdk();
        this.closeables.addAll(Classes.registerObservers((OpenTelemetry)openTelemetry));
        this.closeables.addAll(Cpu.registerObservers((OpenTelemetry)openTelemetry));
        this.closeables.addAll(MemoryPools.registerObservers((OpenTelemetry)openTelemetry));
        this.closeables.addAll(Threads.registerObservers((OpenTelemetry)openTelemetry));
        this.closeables.addAll(GarbageCollector.registerObservers((OpenTelemetry)openTelemetry));
        OpenTelemetryHandler.install((OpenTelemetry)openTelemetry);
        return openTelemetry;
    }

    @Produces
    @Singleton
    public Tracer getTracer() {
        return ((OpenTelemetry)CDI.current().select(OpenTelemetry.class, new Annotation[0]).get()).getTracer("io.smallrye.opentelemetry");
    }

    @Produces
    @Singleton
    public Meter getMeter() {
        return ((OpenTelemetry)CDI.current().select(OpenTelemetry.class, new Annotation[0]).get()).getMeter("io.smallrye.opentelemetry");
    }

    @Produces
    @RequestScoped
    public Span getSpan() {
        return new Span(){

            public <T> Span setAttribute(AttributeKey<T> key, T value) {
                return Span.current().setAttribute(key, value);
            }

            public Span addEvent(String name, Attributes attributes) {
                return Span.current().addEvent(name, attributes);
            }

            public Span addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
                return Span.current().addEvent(name, attributes, timestamp, unit);
            }

            public Span setStatus(StatusCode statusCode, String description) {
                return Span.current().setStatus(statusCode, description);
            }

            public Span recordException(Throwable exception, Attributes additionalAttributes) {
                return Span.current().recordException(exception, additionalAttributes);
            }

            public Span updateName(String name) {
                return Span.current().updateName(name);
            }

            public void end() {
                Span.current().end();
            }

            public void end(long timestamp, TimeUnit unit) {
                Span.current().end(timestamp, unit);
            }

            public SpanContext getSpanContext() {
                return Span.current().getSpanContext();
            }

            public boolean isRecording() {
                return Span.current().isRecording();
            }
        };
    }

    @Produces
    @RequestScoped
    public Baggage getBaggage() {
        return new Baggage(){

            public int size() {
                return Baggage.current().size();
            }

            public void forEach(BiConsumer<? super String, ? super BaggageEntry> consumer) {
                Baggage.current().forEach(consumer);
            }

            public Map<String, BaggageEntry> asMap() {
                return Baggage.current().asMap();
            }

            public String getEntryValue(String entryKey) {
                return Baggage.current().getEntryValue(entryKey);
            }

            public BaggageBuilder toBuilder() {
                return Baggage.current().toBuilder();
            }
        };
    }

    void close(@Disposes OpenTelemetry openTelemetry) throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
        OpenTelemetrySdk openTelemetrySdk = (OpenTelemetrySdk)openTelemetry;
        ArrayList<CompletableResultCode> shutdown = new ArrayList<CompletableResultCode>();
        shutdown.add(openTelemetrySdk.getSdkTracerProvider().shutdown());
        shutdown.add(openTelemetrySdk.getSdkMeterProvider().shutdown());
        shutdown.add(openTelemetrySdk.getSdkLoggerProvider().shutdown());
        CompletableResultCode.ofAll(shutdown).join(10L, TimeUnit.SECONDS);
    }
}

