/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.ItemWithContext;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.UniAwait;
import io.smallrye.mutiny.groups.UniCombine;
import io.smallrye.mutiny.groups.UniConvert;
import io.smallrye.mutiny.groups.UniCreate;
import io.smallrye.mutiny.groups.UniIfNoItem;
import io.smallrye.mutiny.groups.UniJoin;
import io.smallrye.mutiny.groups.UniMemoize;
import io.smallrye.mutiny.groups.UniOnCancel;
import io.smallrye.mutiny.groups.UniOnFailure;
import io.smallrye.mutiny.groups.UniOnItem;
import io.smallrye.mutiny.groups.UniOnItemOrFailure;
import io.smallrye.mutiny.groups.UniOnSubscribe;
import io.smallrye.mutiny.groups.UniOnTerminate;
import io.smallrye.mutiny.groups.UniRepeat;
import io.smallrye.mutiny.groups.UniSubscribe;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Uni<T> {
    @CheckReturnValue
    public static UniCreate createFrom() {
        return UniCreate.INSTANCE;
    }

    @CheckReturnValue
    default public <O> O stage(Function<Uni<T>, O> stage) {
        return ParameterValidation.nonNull(stage, "stage").apply(this);
    }

    @CheckReturnValue
    public static UniCombine combine() {
        return UniCombine.INSTANCE;
    }

    @CheckReturnValue
    public UniSubscribe<T> subscribe();

    @CheckReturnValue
    default public CompletableFuture<T> subscribeAsCompletionStage() {
        return this.subscribe().asCompletionStage();
    }

    @CheckReturnValue
    default public CompletableFuture<T> subscribeAsCompletionStage(Context context) {
        return this.subscribe().asCompletionStage(context);
    }

    @CheckReturnValue
    public UniAwait<T> await();

    @CheckReturnValue
    default public UniAwait<T> awaitUsing(Context context) {
        throw new UnsupportedOperationException("Default method added to limit binary incompatibility");
    }

    @CheckReturnValue
    public UniOnItem<T> onItem();

    @CheckReturnValue
    public UniOnSubscribe<T> onSubscription();

    @CheckReturnValue
    public UniOnItemOrFailure<T> onItemOrFailure();

    @CheckReturnValue
    public UniOnFailure<T> onFailure();

    @CheckReturnValue
    public UniOnFailure<T> onFailure(Predicate<? super Throwable> var1);

    @CheckReturnValue
    public UniOnFailure<T> onFailure(Class<? extends Throwable> var1);

    @CheckReturnValue
    public UniIfNoItem<T> ifNoItem();

    @CheckReturnValue
    public Uni<T> emitOn(Executor var1);

    @CheckReturnValue
    public Uni<T> runSubscriptionOn(Executor var1);

    @CheckReturnValue
    public UniMemoize<T> memoize();

    @CheckReturnValue
    default public <O> Uni<O> map(Function<? super T, ? extends O> mapper) {
        return this.onItem().transform(ParameterValidation.nonNull(mapper, "mapper"));
    }

    @CheckReturnValue
    default public Uni<T> invoke(Consumer<? super T> callback) {
        Consumer<? super T> actual = ParameterValidation.nonNull(callback, "callback");
        return this.onItem().invoke(actual);
    }

    @CheckReturnValue
    default public Uni<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.onItem().invoke(actual);
    }

    @CheckReturnValue
    default public Uni<T> call(Function<? super T, Uni<?>> function) {
        return this.onItem().call(function);
    }

    @CheckReturnValue
    default public Uni<T> call(Supplier<Uni<?>> supplier) {
        return this.onItem().call(supplier);
    }

    @CheckReturnValue
    default public <O> Uni<O> flatMap(Function<? super T, Uni<? extends O>> mapper) {
        return this.onItem().transformToUni(ParameterValidation.nonNull(mapper, "mapper"));
    }

    @CheckReturnValue
    default public <O> Uni<O> chain(Function<? super T, Uni<? extends O>> mapper) {
        Function actual = ParameterValidation.nonNull(mapper, "mapper");
        return this.onItem().transformToUni(actual);
    }

    @CheckReturnValue
    default public <O> Uni<O> chain(Supplier<Uni<? extends O>> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.onItem().transformToUni(ignored -> (Uni)actual.get());
    }

    @CheckReturnValue
    default public Uni<T> eventually(Runnable action) {
        return this.onItemOrFailure().invoke((? super T item, Throwable err) -> ParameterValidation.nonNull(action, "action").run());
    }

    @CheckReturnValue
    default public <O> Uni<T> eventually(Supplier<Uni<? extends O>> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.onItemOrFailure().call((? super T item, Throwable err) -> (Uni)actual.get());
    }

    @CheckReturnValue
    public UniConvert<T> convert();

    @CheckReturnValue
    public Multi<T> toMulti();

    @CheckReturnValue
    public UniRepeat<T> repeat();

    @CheckReturnValue
    public UniOnTerminate<T> onTermination();

    @CheckReturnValue
    public UniOnCancel<T> onCancellation();

    @CheckReturnValue
    default public <R> Uni<R> plug(Function<Uni<T>, Uni<R>> operatorProvider) {
        Function<Uni<Uni>, Uni<R>> provider = ParameterValidation.nonNull(operatorProvider, "operatorProvider");
        return Infrastructure.onUniCreation(ParameterValidation.nonNull(provider.apply(this), "uni"));
    }

    @CheckReturnValue
    default public <O> Uni<O> replaceWith(O item) {
        return this.onItem().transform(ignore -> item);
    }

    @CheckReturnValue
    default public <O> Uni<O> replaceWith(Supplier<O> supplier) {
        return this.onItem().transform(ignore -> supplier.get());
    }

    @CheckReturnValue
    default public <O> Uni<O> replaceWith(Uni<O> uni) {
        return this.onItem().transformToUni(ignore -> uni);
    }

    @CheckReturnValue
    default public Uni<T> replaceWithNull() {
        return this.onItem().transform(ignore -> null);
    }

    @CheckReturnValue
    default public Uni<Void> replaceWithVoid() {
        return this.onItem().transform(ignored -> null);
    }

    @CheckReturnValue
    default public Uni<T> replaceIfNullWith(Supplier<T> supplier) {
        return this.onItem().ifNull().continueWith(supplier);
    }

    @CheckReturnValue
    default public Uni<T> replaceIfNullWith(T value) {
        return this.onItem().ifNull().continueWith(value);
    }

    @CheckReturnValue
    public Uni<T> log(String var1);

    @CheckReturnValue
    public Uni<T> log();

    @CheckReturnValue
    public static UniJoin join() {
        return UniJoin.SHARED_INSTANCE;
    }

    @CheckReturnValue
    default public <R> Uni<R> withContext(BiFunction<Uni<T>, Context, Uni<R>> builder) {
        throw new UnsupportedOperationException("Default method added to limit binary incompatibility");
    }

    @CheckReturnValue
    default public Uni<ItemWithContext<T>> attachContext() {
        return this.withContext((uni, ctx) -> uni.onItem().transform(item -> new ItemWithContext<Object>((Context)ctx, item)));
    }
}

