/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.connector;

import io.smallrye.reactive.messaging.annotations.ConnectorAttribute;
import io.smallrye.reactive.messaging.connector.ClassWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.ConnectorFactory;

public class CommonConfigurationClassWriter {
    private final ProcessingEnvironment environment;

    public CommonConfigurationClassWriter(ProcessingEnvironment environment) {
        this.environment = environment;
    }

    public static void generate(ProcessingEnvironment environment, Connector connector, String className, List<ConnectorAttribute> attributes) throws IOException {
        CommonConfigurationClassWriter writer = new CommonConfigurationClassWriter(environment);
        String packageName = ClassWriter.getPackage(className);
        String configClassName = ClassWriter.getConfigClassName(className, "CommonConfiguration");
        String simpleClassName = ClassWriter.getSimpleClassName(configClassName);
        ClassWriter.log("Generating common configuration for connector `%s`: %s", connector.value(), configClassName);
        writer.generate(attributes, packageName, configClassName, simpleClassName, connector.value());
    }

    private void generate(List<ConnectorAttribute> attributes, String packageName, String className, String simpleName, String connector) throws IOException {
        JavaFileObject file = this.environment.getFiler().createSourceFile(className, new Element[0]);
        file.delete();
        try (PrintWriter out = new PrintWriter(file.openWriter());){
            this.write(attributes, packageName, simpleName, connector, out);
        }
    }

    void write(List<ConnectorAttribute> attributes, String packageName, String simpleName, String connector, PrintWriter out) {
        ClassWriter.writePackageDeclaration(packageName, out);
        ClassWriter.writeImportStatements(out);
        out.println("import " + ConfigProvider.class.getName() + ";");
        out.println("import " + ConnectorFactory.class.getName() + ";");
        this.writeClassDeclaration(simpleName, connector, out);
        this.writeConstructorAndConfigAccessor(simpleName, out);
        attributes.forEach(ca -> ClassWriter.generateGetterForAttribute(ca, connector, out));
        this.writeValidateMethod(attributes, out);
        out.println("}");
    }

    private void writeClassDeclaration(String simpleName, String connector, PrintWriter out) {
        out.println();
        out.println("/**");
        out.println(String.format(" * Extracts the common configuration for the {@code %s} connector.", connector));
        out.println("*/");
        out.println(String.format(" public class %s {", simpleName));
    }

    private void writeConstructorAndConfigAccessor(String simpleName, PrintWriter out) {
        out.println("  protected final Config config;");
        out.println();
        out.println("  /**");
        out.println("   * Creates a new " + simpleName + ".");
        out.println("   */");
        out.println(String.format("  public %s(Config config) {", simpleName));
        out.println("    this.config = config;");
        out.println("  }");
        out.println();
        out.println("  /**");
        out.println("   * @return the connector configuration");
        out.println("   */");
        out.println("  public Config config() {");
        out.println("    return this.config;");
        out.println("  }");
        out.println();
        out.println("  /**");
        out.println("   * Retrieves the value stored for the given alias.");
        out.println("   * @param alias the attribute alias, must not be {@code null} or blank");
        out.println("   * @param type the targeted type");
        out.println("   * @param <T> the targeted type");
        out.println("   * @return the configuration value for the given alias, empty if not set");
        out.println("   */");
        out.println("  protected <T> Optional<T> getFromAlias(String alias, Class<T> type) {");
        out.println("    return ConfigProvider.getConfig().getOptionalValue(alias, type);");
        out.println("  }");
        out.println();
        out.println("  /**");
        out.println("   * Retrieves the value stored for the given alias. Returns the default value if not present.");
        out.println("   * @param alias the attribute alias, must not be {@code null} or blank");
        out.println("   * @param type the targeted type");
        out.println("   * @param defaultValue the default value");
        out.println("   * @param <T> the targeted type");
        out.println("   * @return the configuration value for the given alias, empty if not set");
        out.println("   */");
        out.println("  protected <T> T getFromAliasWithDefaultValue(String alias, Class<T> type, T defaultValue) {");
        out.println("    return getFromAlias(alias, type).orElse(defaultValue);");
        out.println("  }");
        out.println();
        out.println("  /**");
        out.println("   * @return the channel name");
        out.println("   */");
        out.println("  public String getChannel() {");
        out.println("    return config.getValue(ConnectorFactory.CHANNEL_NAME_ATTRIBUTE, String.class);");
        out.println("  }");
        out.println();
    }

    private void writeValidateMethod(List<ConnectorAttribute> attributes, PrintWriter out) {
        out.println("  public void validate() {");
        attributes.forEach(ca -> {
            if (ca.mandatory()) {
                out.println(String.format("    %s();", ClassWriter.getMethodName(ca)));
            }
        });
        out.println("  }");
    }
}

