/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.connector;

import io.smallrye.reactive.messaging.annotations.ConnectorAttribute;
import io.smallrye.reactive.messaging.connector.ClassWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;

public class ConfigurationMarkdownDocWriter {
    private final ProcessingEnvironment environment;

    public ConfigurationMarkdownDocWriter(ProcessingEnvironment env) {
        this.environment = env;
    }

    public void generate(Connector connector, List<ConnectorAttribute> commonAttributes, List<ConnectorAttribute> incomingAttributes, List<ConnectorAttribute> outgoingAttributes) throws IOException {
        this.generateIncomingDocumentation(connector, commonAttributes, incomingAttributes);
        this.generateOutgoingDocumentation(connector, commonAttributes, outgoingAttributes);
    }

    private void generateIncomingDocumentation(Connector connector, List<ConnectorAttribute> commonAttributes, List<ConnectorAttribute> incomingAttributes) throws IOException {
        FileObject resource = this.environment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/connector/" + connector.value() + "-incoming.md", new Element[0]);
        resource.delete();
        try (PrintWriter writer = new PrintWriter(resource.openWriter());){
            this.generateDocumentation(commonAttributes, incomingAttributes, writer);
        }
    }

    private void generateOutgoingDocumentation(Connector connector, List<ConnectorAttribute> commonAttributes, List<ConnectorAttribute> outgoingAttributes) throws IOException {
        FileObject resource = this.environment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/connector/" + connector.value() + "-outgoing.md", new Element[0]);
        resource.delete();
        try (PrintWriter writer = new PrintWriter(resource.openWriter());){
            this.generateDocumentation(commonAttributes, outgoingAttributes, writer);
        }
    }

    void generateDocumentation(List<ConnectorAttribute> commonAttributes, List<ConnectorAttribute> specificAttributes, PrintWriter out) {
        ArrayList<ConnectorAttribute> list = new ArrayList<ConnectorAttribute>(commonAttributes);
        list.addAll(specificAttributes);
        list.sort(Comparator.comparing(ConnectorAttribute::name));
        this.writeTableBegin(out);
        list.forEach(att -> {
            if (!att.hiddenFromDocumentation()) {
                this.generateLine((ConnectorAttribute)att, out);
            }
        });
    }

    private void writeTableBegin(PrintWriter out) {
        out.println("|Attribute (_alias_) | Description | Type   | Mandatory | Default |");
        out.println("| :---               | :----       | :----: | :----:    | :---    |");
    }

    private void generateLine(ConnectorAttribute att, PrintWriter out) {
        String name = "*" + att.name() + "*";
        if (ClassWriter.hasAlias(att)) {
            name = name + " _(" + att.alias() + ")_";
        }
        out.println(String.format("| %s | %s | %s | %s | %s |", name, this.getDescription(att).replace("\n", "").trim(), att.type(), att.mandatory(), this.getDefaultValueOrEmpty(att)));
    }

    private String getDescription(ConnectorAttribute att) {
        if (att.deprecated()) {
            return "_deprecated_ - " + att.description();
        }
        return att.description();
    }

    private String getDefaultValueOrEmpty(ConnectorAttribute att) {
        if (att.defaultValue().equals("<no-value>")) {
            return "";
        }
        return "`" + att.defaultValue() + "`";
    }

    private String getAliasOrEmpty(ConnectorAttribute att) {
        if (att.alias().equals("<no-value>")) {
            return "";
        }
        return att.alias();
    }
}

