/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp.ce;

import io.smallrye.reactive.messaging.amqp.AmqpConnectorOutgoingConfiguration;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.ce.CloudEventMetadata;
import io.smallrye.reactive.messaging.ce.DefaultCloudEventMetadataBuilder;
import io.smallrye.reactive.messaging.ce.IncomingCloudEventMetadata;
import io.smallrye.reactive.messaging.ce.OutgoingCloudEventMetadata;
import io.smallrye.reactive.messaging.ce.impl.BaseCloudEventMetadata;
import io.smallrye.reactive.messaging.ce.impl.DefaultIncomingCloudEventMetadata;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.amqp.AmqpMessageBuilder;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Optional;
import org.apache.qpid.proton.amqp.messaging.Section;

public class AmqpCloudEventHelper {
    public static final String CE_CONTENT_TYPE_PREFIX = "application/cloudevents";
    public static final String CE_HEADER_PREFIX = "cloudEvents:";
    public static final String STRUCTURED_CONTENT_TYPE = "application/cloudevents+json; charset=UTF-8";
    public static final String AMQP_HEADER_FOR_SPEC_VERSION = "cloudEvents:specversion";
    public static final String AMQP_HEADER_FOR_TYPE = "cloudEvents:type";
    public static final String AMQP_HEADER_FOR_SOURCE = "cloudEvents:source";
    public static final String AMQP_HEADER_FOR_ID = "cloudEvents:id";
    public static final String AMQP_HEADER_FOR_SCHEMA = "cloudEvents:dataschema";
    public static final String AMQP_HEADER_FOR_CONTENT_TYPE = "cloudEvents:datacontenttype";
    public static final String AMQP_HEADER_FOR_SUBJECT = "cloudEvents:subject";
    public static final String AMQP_HEADER_FOR_TIME = "cloudEvents:time";
    public static final DateTimeFormatter RFC3339_DATE_FORMAT = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendZoneOrOffsetId().toFormatter();

    private AmqpCloudEventHelper() {
    }

    public static <T> IncomingCloudEventMetadata<T> createFromStructuredCloudEvent(io.vertx.amqp.AmqpMessage message) {
        String time;
        String subject;
        String schema;
        JsonObject content;
        DefaultCloudEventMetadataBuilder builder = new DefaultCloudEventMetadataBuilder();
        Section body = message.unwrap().getBody();
        if (body.getType() == Section.SectionType.AmqpValue) {
            content = new JsonObject(message.bodyAsString());
        } else if (body.getType() == Section.SectionType.Data) {
            content = message.bodyAsBinary().toJsonObject();
        } else {
            throw new IllegalArgumentException("Invalid value type. Structured Cloud Event can only be created from String, JsonObject and byte[]");
        }
        builder.withSpecVersion(content.getString("specversion"));
        builder.withId(content.getString("id"));
        String source = content.getString("source");
        if (source == null) {
            throw new IllegalArgumentException("The JSON value must contain the source attribute");
        }
        builder.withSource(URI.create(source));
        builder.withType(content.getString("type"));
        String ct = content.getString("datacontenttype");
        if (ct != null) {
            builder.withDataContentType(ct);
        }
        if ((schema = content.getString("dataschema")) != null) {
            builder.withDataSchema(URI.create(schema));
        }
        if ((subject = content.getString("subject")) != null) {
            builder.withSubject(subject);
        }
        if ((time = content.getString("time")) != null) {
            builder.withTimestamp(ZonedDateTime.parse(time, RFC3339_DATE_FORMAT));
        }
        Object data = content.getValue("data");
        builder.withData(data);
        BaseCloudEventMetadata cloudEventMetadata = builder.build();
        cloudEventMetadata.validate();
        return new DefaultIncomingCloudEventMetadata((CloudEventMetadata)cloudEventMetadata);
    }

    public static <T> IncomingCloudEventMetadata<T> createFromBinaryCloudEvent(io.vertx.amqp.AmqpMessage message, AmqpMessage<T> parent) {
        String time;
        String subject;
        String schema;
        DefaultCloudEventMetadataBuilder builder = new DefaultCloudEventMetadataBuilder();
        JsonObject applicationProperties = message.applicationProperties().copy();
        builder.withSpecVersion(applicationProperties.getString(AMQP_HEADER_FOR_SPEC_VERSION));
        builder.withId(applicationProperties.getString(AMQP_HEADER_FOR_ID));
        String source = applicationProperties.getString(AMQP_HEADER_FOR_SOURCE);
        if (source == null) {
            throw new IllegalArgumentException("The Kafka record must contain the cloudEvents:source header");
        }
        builder.withSource(URI.create(source));
        builder.withType(applicationProperties.getString(AMQP_HEADER_FOR_TYPE));
        String ct = message.contentType();
        if (ct != null) {
            builder.withDataContentType(ct);
        }
        if ((schema = applicationProperties.getString(AMQP_HEADER_FOR_SCHEMA)) != null) {
            builder.withDataSchema(URI.create(schema));
        }
        if ((subject = applicationProperties.getString(AMQP_HEADER_FOR_SUBJECT)) != null) {
            builder.withSubject(subject);
        }
        if ((time = applicationProperties.getString(AMQP_HEADER_FOR_TIME)) != null) {
            ZonedDateTime parse = ZonedDateTime.parse(time, RFC3339_DATE_FORMAT);
            builder.withTimestamp(parse);
        }
        applicationProperties.remove(AMQP_HEADER_FOR_SPEC_VERSION);
        applicationProperties.remove(AMQP_HEADER_FOR_ID);
        applicationProperties.remove(AMQP_HEADER_FOR_SOURCE);
        applicationProperties.remove(AMQP_HEADER_FOR_TYPE);
        applicationProperties.remove(AMQP_HEADER_FOR_SCHEMA);
        applicationProperties.remove(AMQP_HEADER_FOR_SUBJECT);
        applicationProperties.remove(AMQP_HEADER_FOR_TIME);
        applicationProperties.forEach(entry -> {
            if (((String)entry.getKey()).startsWith(CE_HEADER_PREFIX)) {
                String key = ((String)entry.getKey()).substring(CE_HEADER_PREFIX.length());
                builder.withExtension(key, entry.getValue());
            }
        });
        builder.withData(parent.getPayload());
        BaseCloudEventMetadata cloudEventMetadata = builder.build();
        return new DefaultIncomingCloudEventMetadata((CloudEventMetadata)cloudEventMetadata);
    }

    public static io.vertx.mutiny.amqp.AmqpMessage createBinaryCloudEventMessage(io.vertx.mutiny.amqp.AmqpMessage message, OutgoingCloudEventMetadata<?> ceMetadata, AmqpConnectorOutgoingConfiguration configuration) {
        if (ceMetadata == null) {
            ceMetadata = OutgoingCloudEventMetadata.builder().build();
        }
        Optional<String> subject = AmqpCloudEventHelper.getSubject(ceMetadata, configuration);
        Optional<String> contentType = AmqpCloudEventHelper.getDataContentType(ceMetadata, configuration);
        Optional<URI> schema = AmqpCloudEventHelper.getDataSchema(ceMetadata, configuration);
        AmqpMessageBuilder builder = io.vertx.mutiny.amqp.AmqpMessage.create((io.vertx.mutiny.amqp.AmqpMessage)message);
        JsonObject app = new JsonObject();
        app.put(AMQP_HEADER_FOR_SPEC_VERSION, (Object)ceMetadata.getSpecVersion());
        app.put(AMQP_HEADER_FOR_ID, (Object)ceMetadata.getId());
        String type = AmqpCloudEventHelper.getType(ceMetadata, configuration);
        app.put(AMQP_HEADER_FOR_TYPE, (Object)type);
        String source = AmqpCloudEventHelper.getSource(ceMetadata, configuration);
        app.put(AMQP_HEADER_FOR_SOURCE, (Object)source);
        subject.ifPresent(s -> app.put(AMQP_HEADER_FOR_SUBJECT, s));
        if (contentType.isPresent()) {
            app.put(AMQP_HEADER_FOR_CONTENT_TYPE, (Object)contentType.get());
            builder.contentType(contentType.get());
        } else if (message.contentType() != null) {
            app.put(AMQP_HEADER_FOR_CONTENT_TYPE, (Object)message.contentType());
        }
        schema.ifPresent(s -> app.put(AMQP_HEADER_FOR_SCHEMA, (Object)s.toString()));
        Optional ts = ceMetadata.getTimeStamp();
        if (ts.isPresent()) {
            ZonedDateTime time = (ZonedDateTime)ts.get();
            app.put(AMQP_HEADER_FOR_TIME, (Object)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(time));
        } else if (configuration.getCloudEventsInsertTimestamp().booleanValue()) {
            ZonedDateTime now = ZonedDateTime.now();
            app.put(AMQP_HEADER_FOR_TIME, (Object)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(now));
        }
        ceMetadata.getExtensions().forEach((k, v) -> {
            if (v != null) {
                app.put(CE_HEADER_PREFIX + k, v);
            }
        });
        if (message.applicationProperties() != null) {
            builder.applicationProperties(app.mergeIn(message.applicationProperties()));
        } else {
            builder.applicationProperties(app);
        }
        return builder.build();
    }

    private static String getSource(OutgoingCloudEventMetadata<?> ceMetadata, AmqpConnectorOutgoingConfiguration configuration) {
        String source;
        String string = source = ceMetadata.getSource() != null ? ceMetadata.getSource().toString() : null;
        if (source == null) {
            source = configuration.getCloudEventsSource().orElseThrow(() -> new IllegalArgumentException("Cannot build the Cloud Event Record - source is not set"));
        }
        return source;
    }

    private static String getType(OutgoingCloudEventMetadata<?> ceMetadata, AmqpConnectorOutgoingConfiguration configuration) {
        String type = ceMetadata.getType();
        if (type == null) {
            type = configuration.getCloudEventsType().orElseThrow(() -> new IllegalArgumentException("Cannot build the Cloud Event Record - type is not set"));
        }
        return type;
    }

    private static Optional<String> getSubject(OutgoingCloudEventMetadata<?> ceMetadata, AmqpConnectorOutgoingConfiguration configuration) {
        if (ceMetadata.getSubject().isPresent()) {
            return ceMetadata.getSubject();
        }
        return configuration.getCloudEventsSubject();
    }

    private static Optional<URI> getDataSchema(OutgoingCloudEventMetadata<?> ceMetadata, AmqpConnectorOutgoingConfiguration configuration) {
        if (ceMetadata.getDataSchema().isPresent()) {
            return ceMetadata.getDataSchema();
        }
        return configuration.getCloudEventsDataSchema().map(URI::create);
    }

    private static Optional<String> getDataContentType(OutgoingCloudEventMetadata<?> ceMetadata, AmqpConnectorOutgoingConfiguration configuration) {
        if (ceMetadata.getDataContentType().isPresent()) {
            return ceMetadata.getDataContentType();
        }
        return configuration.getCloudEventsDataContentType();
    }

    public static io.vertx.mutiny.amqp.AmqpMessage createStructuredEventMessage(io.vertx.mutiny.amqp.AmqpMessage message, OutgoingCloudEventMetadata<?> ceMetadata, AmqpConnectorOutgoingConfiguration configuration) {
        if (ceMetadata == null) {
            ceMetadata = OutgoingCloudEventMetadata.builder().build();
        }
        AmqpMessageBuilder builder = io.vertx.mutiny.amqp.AmqpMessage.create((io.vertx.mutiny.amqp.AmqpMessage)message);
        String source = AmqpCloudEventHelper.getSource(ceMetadata, configuration);
        String type = AmqpCloudEventHelper.getType(ceMetadata, configuration);
        Optional<String> subject = AmqpCloudEventHelper.getSubject(ceMetadata, configuration);
        Optional<String> dataContentType = AmqpCloudEventHelper.getDataContentType(ceMetadata, configuration);
        Optional<URI> schema = AmqpCloudEventHelper.getDataSchema(ceMetadata, configuration);
        JsonObject json = new JsonObject();
        json.put("specversion", (Object)ceMetadata.getSpecVersion()).put("type", (Object)type).put("source", (Object)source).put("id", (Object)ceMetadata.getId());
        ZonedDateTime time = ceMetadata.getTimeStamp().orElse(null);
        if (time != null) {
            json.put("time", (Object)time.toInstant());
        } else if (configuration.getCloudEventsInsertTimestamp().booleanValue()) {
            json.put("time", (Object)Instant.now());
        }
        schema.ifPresent(s -> json.put("dataschema", s));
        dataContentType.ifPresent(s -> json.put("datacontenttype", s));
        subject.ifPresent(s -> json.put("subject", s));
        ceMetadata.getExtensions().forEach((arg_0, arg_1) -> ((JsonObject)json).put(arg_0, arg_1));
        if (message.getDelegate().unwrap().getBody().getType() == Section.SectionType.AmqpValue) {
            json.put("data", (Object)message.bodyAsString());
        } else if (message.getDelegate().unwrap().getBody().getType() == Section.SectionType.Data) {
            json.put("data", (Object)message.bodyAsJsonObject());
        } else {
            throw new UnsupportedOperationException("Invalid payload for structure cloud events: " + String.valueOf(message.getDelegate().unwrap().getBody()));
        }
        builder.withJsonObjectAsBody(json);
        if (message.contentType() == null || !message.contentType().startsWith(CE_CONTENT_TYPE_PREFIX)) {
            builder.contentType(STRUCTURED_CONTENT_TYPE);
        }
        return builder.build();
    }

    public static CloudEventMode getCloudEventMode(io.vertx.amqp.AmqpMessage incoming) {
        String contentType = incoming.contentType();
        if (contentType != null && contentType.startsWith(CE_CONTENT_TYPE_PREFIX)) {
            return CloudEventMode.STRUCTURED;
        }
        if (AmqpCloudEventHelper.containsAllMandatoryAttributes(incoming)) {
            return CloudEventMode.BINARY;
        }
        return CloudEventMode.NOT_A_CLOUD_EVENT;
    }

    private static boolean containsAllMandatoryAttributes(io.vertx.amqp.AmqpMessage incoming) {
        JsonObject app = incoming.applicationProperties();
        if (app == null || app.isEmpty()) {
            return false;
        }
        return app.getString(AMQP_HEADER_FOR_ID) != null && app.getString(AMQP_HEADER_FOR_SOURCE) != null && app.getString(AMQP_HEADER_FOR_TYPE) != null && app.getString(AMQP_HEADER_FOR_SPEC_VERSION) != null;
    }

    public static enum CloudEventMode {
        STRUCTURED,
        BINARY,
        NOT_A_CLOUD_EVENT;

    }
}

