/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.companion;

import io.smallrye.reactive.messaging.kafka.companion.KafkaCompanion;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.TopicPartition;

public class OffsetsCompanion {
    final AdminClient adminClient;
    final Duration kafkaApiTimeout;

    public OffsetsCompanion(AdminClient adminClient, Duration kafkaApiTimeout) {
        this.adminClient = adminClient;
        this.kafkaApiTimeout = kafkaApiTimeout;
    }

    public Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> list(Map<TopicPartition, OffsetSpec> partitions) {
        return (Map)KafkaCompanion.toUni(() -> this.adminClient.listOffsets(partitions).all()).await().atMost(this.kafkaApiTimeout);
    }

    public Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> list(List<TopicPartition> partitions) {
        return this.list(partitions.stream().collect(Collectors.toMap(Function.identity(), tp -> OffsetSpec.latest())));
    }

    public ListOffsetsResult.ListOffsetsResultInfo get(TopicPartition topicPartition, OffsetSpec offsetSpec) {
        HashMap<TopicPartition, OffsetSpec> offsets = new HashMap<TopicPartition, OffsetSpec>();
        offsets.put(topicPartition, offsetSpec);
        return (ListOffsetsResult.ListOffsetsResultInfo)KafkaCompanion.toUni(() -> this.adminClient.listOffsets(offsets).partitionResult(topicPartition)).await().atMost(this.kafkaApiTimeout);
    }
}

