/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import java.util.Objects;

public class ProcessingState<T> {
    private long offset;
    private T state;
    public static ProcessingState<?> EMPTY_STATE = new ProcessingState<Object>(null, 0L);

    public static boolean isEmptyOrNull(ProcessingState<?> state) {
        return state == null || EMPTY_STATE.equals(state);
    }

    public static <V> ProcessingState<V> getOrDefault(ProcessingState<V> state, ProcessingState<V> defaultValue) {
        return ProcessingState.isEmptyOrNull(state) ? defaultValue : state;
    }

    public static <V> ProcessingState<V> getOrDefault(ProcessingState<V> state, V defaultValue) {
        return ProcessingState.getOrDefault(state, new ProcessingState<V>(defaultValue, 0L));
    }

    public static <V> ProcessingState<V> getOrEmpty(ProcessingState<V> state) {
        return ProcessingState.getOrDefault(state, EMPTY_STATE);
    }

    public ProcessingState(T state, long offset) {
        this.state = state;
        this.offset = offset;
    }

    public ProcessingState() {
    }

    public T getState() {
        return this.state;
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setState(T state) {
        this.state = state;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessingState state1 = (ProcessingState)o;
        return this.offset == state1.offset && Objects.equals(this.state, state1.state);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.state);
    }

    public String toString() {
        return "ProcessingState{offset=" + this.offset + ", state=" + String.valueOf(this.state) + "}";
    }
}

