/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.reactive.messaging.kafka.KafkaRecord;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;

public class TopicPartitions {
    private static final Map<String, Map<Integer, TopicPartition>> TOPIC_PARTITIONS_CACHE = new ConcurrentHashMap<String, Map<Integer, TopicPartition>>();

    public static void clearCache() {
        TOPIC_PARTITIONS_CACHE.clear();
    }

    public static TopicPartition getTopicPartition(String topic, int partition) {
        return TOPIC_PARTITIONS_CACHE.computeIfAbsent(topic, t -> new ConcurrentHashMap()).computeIfAbsent(partition, p -> new TopicPartition(topic, partition));
    }

    public static TopicPartition getTopicPartition(KafkaRecord<?, ?> record) {
        return TopicPartitions.getTopicPartition(record.getTopic(), record.getPartition());
    }
}

