/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.smallrye.reactive.messaging.mqtt.SendingMqttMessage;
import io.smallrye.reactive.messaging.mqtt.SendingMqttMessageMetadata;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public interface MqttMessage<T>
extends ContextAwareMessage<T> {
    public static <T> MqttMessage<T> of(T payload) {
        return new SendingMqttMessage<T>(payload, new SendingMqttMessageMetadata(null, null, false), null);
    }

    public static <T> MqttMessage<T> of(SendingMqttMessageMetadata metadata, T payload) {
        return new SendingMqttMessage<T>(payload, metadata, null);
    }

    public static <T> MqttMessage<T> of(SendingMqttMessageMetadata metadata, T payload, Supplier<CompletionStage<Void>> ack) {
        return new SendingMqttMessage<T>(payload, metadata, ack);
    }

    public static <T> MqttMessage<T> of(String topic, T payload) {
        return new SendingMqttMessage<T>(payload, new SendingMqttMessageMetadata(topic, null, false), null);
    }

    public static <T> MqttMessage<T> of(String topic, T payload, Supplier<CompletionStage<Void>> ack) {
        return new SendingMqttMessage<T>(payload, new SendingMqttMessageMetadata(topic, null, false), ack);
    }

    public static <T> MqttMessage<T> of(String topic, T payload, MqttQoS qos) {
        return new SendingMqttMessage<T>(payload, new SendingMqttMessageMetadata(topic, qos, false));
    }

    public static <T> MqttMessage<T> of(String topic, T payload, MqttQoS qos, boolean retain) {
        return new SendingMqttMessage<T>(payload, new SendingMqttMessageMetadata(topic, qos, retain));
    }

    default public MqttMessage<T> withAck(Supplier<CompletionStage<Void>> ack) {
        return new SendingMqttMessage<Object>(this.getPayload(), new SendingMqttMessageMetadata(this.getTopic(), this.getQosLevel(), this.isRetain()), ack);
    }

    public int getMessageId();

    public MqttQoS getQosLevel();

    public boolean isDuplicate();

    public boolean isRetain();

    public String getTopic();
}

