/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.providers.helpers.VertxContext;
import io.smallrye.reactive.messaging.rabbitmq.IncomingRabbitMQMessage;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQExceptions;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQLogging;
import io.vertx.core.Context;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.rabbitmq.RabbitMQClient;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public class ClientHolder {
    private final RabbitMQClient client;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final AtomicReference<CurrentConnection> connectionHolder = new AtomicReference();
    private final Uni<RabbitMQClient> connection;
    private final Vertx vertx;

    public ClientHolder(RabbitMQClient client, RabbitMQConnectorCommonConfiguration configuration, Vertx vertx, io.vertx.mutiny.core.Context root) {
        this.client = client;
        this.vertx = vertx;
        this.connection = Uni.createFrom().deferred(() -> client.start().onSubscription().invoke(() -> {
            this.connected.set(true);
            RabbitMQLogging.log.connectionEstablished(configuration.getChannel());
        }).onItem().transform(ignored -> {
            this.connectionHolder.set(new CurrentConnection(client, root == null ? Vertx.currentContext() : root));
            if (!client.isConnected() || this.connectionHolder.get() == null) {
                this.connectionHolder.set(null);
                throw RabbitMQExceptions.ex.illegalStateConnectionDisconnected();
            }
            return client;
        }).onFailure().invoke(RabbitMQLogging.log::unableToConnectToBroker).onFailure().invoke(t -> {
            this.connectionHolder.set(null);
            RabbitMQLogging.log.unableToRecoverFromConnectionDisruption((Throwable)t);
        })).memoize().until(() -> {
            CurrentConnection connection = this.connectionHolder.get();
            if (connection == null) {
                return true;
            }
            return !connection.client.isConnected();
        });
    }

    public static CompletionStage<Void> runOnContext(io.vertx.mutiny.core.Context context, IncomingRabbitMQMessage<?> msg, Consumer<IncomingRabbitMQMessage<?>> handle) {
        return VertxContext.runOnContext((Context)context.getDelegate(), f -> {
            handle.accept(msg);
            msg.runOnMessageContext(() -> f.complete(null));
        });
    }

    public static CompletionStage<Void> runOnContextAndReportFailure(io.vertx.mutiny.core.Context context, Throwable reason, IncomingRabbitMQMessage<?> msg, Consumer<IncomingRabbitMQMessage<?>> handle) {
        return VertxContext.runOnContext((Context)context.getDelegate(), f -> {
            handle.accept(msg);
            msg.runOnMessageContext(() -> f.completeExceptionally(reason));
        });
    }

    public io.vertx.mutiny.core.Context getContext() {
        CurrentConnection connection = this.connectionHolder.get();
        if (connection != null) {
            return connection.context;
        }
        return null;
    }

    public RabbitMQClient client() {
        return this.client;
    }

    public boolean hasBeenConnected() {
        return this.connected.get();
    }

    @CheckReturnValue
    public Uni<Void> getAck(long deliveryTag) {
        return this.client.basicAck(deliveryTag, false);
    }

    public Function<Throwable, Uni<Void>> getNack(long deliveryTag, boolean requeue) {
        return t -> this.client.basicNack(deliveryTag, false, requeue);
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    @CheckReturnValue
    public Uni<RabbitMQClient> getOrEstablishConnection() {
        return this.connection;
    }

    private static class CurrentConnection {
        final RabbitMQClient client;
        final io.vertx.mutiny.core.Context context;

        private CurrentConnection(RabbitMQClient client, io.vertx.mutiny.core.Context context) {
            this.client = client;
            this.context = context;
        }
    }
}

