/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq.tracing;

import java.util.Map;

public class RabbitMQTrace {
    private final String destinationKind;
    private final String destination;
    private final String routingKey;
    private final Map<String, Object> headers;

    private RabbitMQTrace(String destinationKind, String destination, String routingKey, Map<String, Object> headers) {
        this.destination = destination;
        this.routingKey = routingKey;
        this.headers = headers;
        this.destinationKind = destinationKind;
    }

    public String getDestinationKind() {
        return this.destinationKind;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public static RabbitMQTrace traceQueue(String destination, String routingKey, Map<String, Object> headers) {
        return new RabbitMQTrace("queue", destination, routingKey, headers);
    }

    public static RabbitMQTrace traceExchange(String destination, String routingKey, Map<String, Object> headers) {
        return new RabbitMQTrace("exchange", destination, routingKey, headers);
    }
}

