/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class DirConfigSource
implements ConfigSource {
    private static final int DEFAULT_ORDINAL = 100;
    private final File dir;
    private final int ordinal;
    private final Map<String, String> props;

    DirConfigSource(File dir) {
        this(dir, 100);
    }

    public DirConfigSource(File dir, int ordinal) {
        this.dir = dir;
        this.ordinal = ordinal;
        this.props = this.scan();
    }

    private Map<String, String> scan() {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.dir == null || !this.dir.isDirectory()) {
            return props;
        }
        for (File file : this.dir.listFiles()) {
            if (file.isDirectory()) continue;
            try {
                String key = file.getName();
                String value = this.readContent(file);
                props.put(key, value);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }

    private String readContent(File file) throws IOException {
        String content = Files.lines(file.toPath()).collect(Collectors.joining());
        return content;
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    public String getValue(String key) {
        return this.props.get(key);
    }

    public String getName() {
        return "DirConfigSource[dir=" + this.dir.getAbsolutePath() + "]";
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

