/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timer;

import io.smallrye.faulttolerance.core.timer.TimerLogger;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public final class TimerTask {
    static final int STATE_NEW = 0;
    static final int STATE_RUNNING = 1;
    static final int STATE_FINISHED = 2;
    static final int STATE_CANCELLED = 3;
    final long startTime;
    final Runnable runnable;
    final Executor executorOverride;
    final AtomicInteger state = new AtomicInteger(0);
    private final Consumer<TimerTask> onCancel;

    TimerTask(long startTime, Runnable runnable, Consumer<TimerTask> onCancel, Executor executorOverride) {
        this.startTime = startTime;
        this.runnable = Preconditions.checkNotNull(runnable, "Runnable task must be set");
        this.onCancel = Preconditions.checkNotNull(onCancel, "Cancellation callback must be set");
        this.executorOverride = executorOverride;
    }

    public boolean isDone() {
        int state = this.state.get();
        return state == 2 || state == 3;
    }

    public boolean cancel() {
        if (this.state.compareAndSet(0, 3)) {
            TimerLogger.LOG.cancelledTimerTask(this);
            this.onCancel.accept(this);
            return true;
        }
        return false;
    }
}

