/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core;

import io.smallrye.faulttolerance.core.Completer;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;

public interface Future<T> {
    public static <T> Future<T> of(T value) {
        Completer<T> completer = Completer.create();
        completer.complete(value);
        return completer.future();
    }

    public static <T> Future<T> ofError(Throwable error) {
        Completer completer = Completer.create();
        completer.completeWithError(error);
        return completer.future();
    }

    public static <T> Future<T> from(Callable<T> callable) {
        Completer<T> completer = Completer.create();
        try {
            T result = callable.call();
            completer.complete(result);
        }
        catch (Exception e) {
            completer.completeWithError(e);
        }
        return completer.future();
    }

    public void then(BiConsumer<T, Throwable> var1);

    public void thenComplete(Completer<T> var1);

    public boolean isComplete();

    public boolean isCancelled();

    public T awaitBlocking() throws Throwable;

    public void cancel();
}

